/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.gen.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.Objects;
import org.springframework.validation.annotation.Validated;

@Validated
public class Tenant {
    @JsonProperty(value="tenantKey")
    private String tenantKey = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="description")
    private String description = null;
    @JsonProperty(value="data")
    private Object data = null;

    public Tenant tenantKey(String tenantKey) {
        this.tenantKey = tenantKey;
        return this;
    }

    @ApiModelProperty(required=true, value="Unique tenant key. Alpha-numeric string with underscores. First alpha character. Not start with 'pg_'. Max length is 48")
    @NotNull
    @Pattern(regexp="^(?!commons$)(?!pg_)(?!_)[a-zA-Z][a-zA-Z0-9_]{0,47}$")
    public @NotNull @Pattern(regexp="^(?!commons$)(?!pg_)(?!_)[a-zA-Z][a-zA-Z0-9_]{0,47}$") String getTenantKey() {
        return this.tenantKey;
    }

    public void setTenantKey(String tenantKey) {
        this.tenantKey = tenantKey;
    }

    public Tenant name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="Tenant name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Tenant description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="Tenant desciption")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Tenant data(Object data) {
        this.data = data;
        return this;
    }

    @ApiModelProperty(value="Tenant additional data")
    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tenant tenant = (Tenant)o;
        return Objects.equals(this.tenantKey, tenant.tenantKey) && Objects.equals(this.name, tenant.name) && Objects.equals(this.description, tenant.description) && Objects.equals(this.data, tenant.data);
    }

    public int hashCode() {
        return Objects.hash(this.tenantKey, this.name, this.description, this.data);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Tenant {");
        sb.append("tenantKey: ").append(this.toOneLineString(this.tenantKey)).append(", ");
        sb.append("name: ").append(this.toOneLineString(this.name)).append(", ");
        sb.append("description: ").append(this.toOneLineString(this.description)).append(", ");
        sb.append("data: ").append(this.toOneLineString(this.data)).append(", ");
        sb.append("}").deleteCharAt(sb.toString().lastIndexOf(","));
        return sb.toString();
    }

    private String toOneLineString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", " ");
    }
}

