/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.tenantendpoint.provisioner;

import com.icthh.xm.commons.exceptions.BusinessException;
import com.icthh.xm.commons.gen.model.Tenant;
import com.icthh.xm.commons.tenant.TenantContextHolder;
import com.icthh.xm.commons.tenant.TenantContextUtils;
import com.icthh.xm.commons.tenantendpoint.provisioner.TenantProvisioner;
import java.util.Collections;
import java.util.Set;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class TenantAbilityCheckerProvisioner
implements TenantProvisioner {
    private final TenantContextHolder tenantContextHolder;
    private final Set<String> allowedTenants;

    public TenantAbilityCheckerProvisioner(TenantContextHolder tenantContextHolder, @Value(value="${application.tenant-with-creation-access-list:#{T(java.util.Set).of('XM')}}") Set<String> allowedTenants) {
        this.tenantContextHolder = tenantContextHolder;
        this.allowedTenants = Collections.unmodifiableSet(allowedTenants);
    }

    @Override
    public void createTenant(Tenant tenant) {
        this.assertCanManageTenant("create new");
    }

    @Override
    public void manageTenant(String tenantKey, String state) {
        this.assertCanManageTenant("manage");
    }

    @Override
    public void deleteTenant(String tenantKey) {
        this.assertCanManageTenant("delete");
    }

    protected void assertCanManageTenant(String action) {
        if (!this.allowedTenants.contains(TenantContextUtils.getRequiredTenantKeyValue((TenantContextHolder)this.tenantContextHolder))) {
            throw new BusinessException("Only " + String.valueOf(this.allowedTenants) + String.format(" tenants allowed to %s tenant", action));
        }
    }
}

