/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.tenant.internal;

import com.icthh.xm.commons.tenant.Tenant;
import com.icthh.xm.commons.tenant.internal.ValueHolder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Stack;
import java.util.function.Consumer;
import java.util.function.Supplier;

final class TenantContextDataHolder {
    private static ThreadLocal<TenantContextDataHolder> holderInstance = ThreadLocal.withInitial(TenantContextDataHolder::new);
    private static ThreadLocal<Stack<TenantContextDataHolder>> parentHolderInstanceStack = ThreadLocal.withInitial(Stack::new);
    private ValueHolder<Tenant> tenant = ValueHolder.empty();
    private ValueHolder<Map<String, Object>> dataMap = ValueHolder.empty();

    private TenantContextDataHolder() {
    }

    static TenantContextDataHolder getThreadLocalInstance() {
        return holderInstance.get();
    }

    private boolean isAllowedToChangeTenant(StackTraceElement[] traces) {
        return traces != null && traces.length > 0;
    }

    Optional<Tenant> getTenant() {
        return this.tenant.isPresent() ? Optional.of(this.tenant.get()) : Optional.empty();
    }

    void setTenant(Tenant tenant) {
        StackTraceElement[] traces;
        Objects.requireNonNull(tenant, "tenant can't be null");
        if (this.tenant.isEmpty() || this.tenant.get().isSuper()) {
            this.tenant = ValueHolder.valueOf(tenant);
        } else if (!Objects.equals(this.tenant.get(), tenant) && !this.isAllowedToChangeTenant(traces = Thread.currentThread().getStackTrace())) {
            throw new IllegalStateException("Trying to set the tenant from " + this.tenant + " to " + tenant);
        }
    }

    private Map<String, Object> getRequiredData() {
        return this.dataMap.orElseThrow(() -> new IllegalStateException("data instance not initialized in TenantContext"));
    }

    Object getDataValue(String key) {
        return this.getRequiredData().get(key);
    }

    Map<String, Object> getData() {
        return new HashMap<String, Object>(this.getRequiredData());
    }

    void setData(Map<String, Object> data) {
        Objects.requireNonNull(data, "data can't be null");
        if (this.dataMap.isEmpty()) {
            this.dataMap = ValueHolder.valueOf(data);
        } else if (!Objects.equals(this.dataMap.get(), data)) {
            if (!this.tenant.isPresent()) {
                throw new IllegalStateException("Tenant doesn't set in context yet");
            }
            if (this.tenant.get().isSuper()) {
                this.dataMap = ValueHolder.valueOf(data);
            } else {
                StackTraceElement[] traces = Thread.currentThread().getStackTrace();
                if (!this.isAllowedToChangeTenant(traces)) {
                    throw new IllegalStateException("Trying to set the data from " + this.dataMap.get() + " to " + data);
                }
            }
        }
    }

    private static void startTenantFlow() {
        Stack<TenantContextDataHolder> contextDataStack = parentHolderInstanceStack.get();
        contextDataStack.push(holderInstance.get());
        holderInstance.remove();
    }

    private static void endTenantFlow() {
        Stack<TenantContextDataHolder> contextDataStack = parentHolderInstanceStack.get();
        if (contextDataStack != null) {
            holderInstance.set(contextDataStack.pop());
        }
    }

    void destroyForCurrentThread() {
        holderInstance.remove();
        parentHolderInstanceStack.remove();
    }

    boolean isInitialized() {
        return !this.tenant.isEmpty();
    }

    static <V> V execute(Tenant tenant, Supplier<V> supplier) {
        TenantContextDataHolder.startTenantFlow();
        try {
            TenantContextDataHolder.getThreadLocalInstance().setTenant(tenant);
            V v = supplier.get();
            return v;
        }
        finally {
            TenantContextDataHolder.endTenantFlow();
        }
    }

    static void execute(Tenant tenant, Runnable runnable) {
        TenantContextDataHolder.startTenantFlow();
        try {
            TenantContextDataHolder.getThreadLocalInstance().setTenant(tenant);
            runnable.run();
        }
        finally {
            TenantContextDataHolder.endTenantFlow();
        }
    }

    static <V> void execute(Tenant tenant, Consumer<V> consumer, V value) {
        TenantContextDataHolder.startTenantFlow();
        try {
            TenantContextDataHolder.getThreadLocalInstance().setTenant(tenant);
            consumer.accept(value);
        }
        finally {
            TenantContextDataHolder.endTenantFlow();
        }
    }
}

