/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.tenant.internal;

import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Supplier;

final class ValueHolder<T> {
    private static volatile ValueHolder<?> emptyInstance = new ValueHolder();
    private final T value;

    private ValueHolder() {
        this.value = null;
    }

    private ValueHolder(T value) {
        this.value = Objects.requireNonNull(value);
    }

    static <T> ValueHolder<T> empty() {
        return emptyInstance;
    }

    static <T> ValueHolder<T> valueOf(T value) {
        return new ValueHolder<T>(value);
    }

    boolean isPresent() {
        return this.value != null;
    }

    boolean isEmpty() {
        return this == emptyInstance;
    }

    T get() {
        if (this.value == null) {
            throw new NoSuchElementException("No value present");
        }
        return this.value;
    }

    <X extends Throwable> T orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        if (this.isPresent()) {
            return this.value;
        }
        throw (Throwable)exceptionSupplier.get();
    }
}

