/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.tenant;

import com.icthh.xm.commons.exceptions.BusinessException;
import com.icthh.xm.commons.tenant.PlainTenant;
import com.icthh.xm.commons.tenant.Tenant;
import com.icthh.xm.commons.tenant.TenantContext;
import com.icthh.xm.commons.tenant.TenantContextHolder;
import com.icthh.xm.commons.tenant.TenantKey;
import java.util.Optional;
import java.util.regex.Pattern;

public final class TenantContextUtils {
    public static String TENANT_KEY_REGEXP = "^(?!commons$)(?!pg_)(?!_)[a-zA-Z][a-zA-Z0-9_]{0,47}$";
    public static Pattern TENANT_KEY_PATTERN = Pattern.compile(TENANT_KEY_REGEXP);
    public static final String TENANT_KEY_FORMAT_CODE = "xm.xmEntity.tenant.error.tenantKeyFormat";

    public static String getRequiredTenantKeyValue(TenantContextHolder holder) {
        return TenantContextUtils.getRequiredTenantKeyValue(holder.getContext());
    }

    public static String getRequiredTenantKeyValue(TenantContext context) {
        return TenantContextUtils.getRequiredTenantKey(context).getValue();
    }

    public static TenantKey getRequiredTenantKey(TenantContextHolder holder) {
        return TenantContextUtils.getRequiredTenantKey(holder.getContext());
    }

    public static TenantKey getRequiredTenantKey(TenantContext context) {
        return context.getTenantKey().orElseThrow(() -> new IllegalStateException("Tenant context doesn't have tenant key"));
    }

    public static Optional<TenantKey> getTenantKey(TenantContextHolder holder) {
        return holder.getContext().getTenantKey();
    }

    public static void setTenant(TenantContextHolder holder, String tenantKeyValue) {
        holder.getPrivilegedContext().setTenant(TenantContextUtils.buildTenant(tenantKeyValue));
    }

    public static void setTenant(TenantContextHolder holder, TenantKey tenantKey) {
        holder.getPrivilegedContext().setTenant(TenantContextUtils.buildTenant(tenantKey));
    }

    public static Tenant buildTenant(String tenantKeyValue) {
        return TenantContextUtils.buildTenant(TenantKey.valueOf(tenantKeyValue));
    }

    public static Tenant buildTenant(TenantKey tenantKey) {
        return new PlainTenant(tenantKey);
    }

    public static boolean isTenantKeyValid(String tenantKey) {
        return TENANT_KEY_PATTERN.matcher(tenantKey).matches();
    }

    public static void assertTenantKeyValid(String tenantKey) {
        if (!TenantContextUtils.isTenantKeyValid(tenantKey)) {
            throw new BusinessException(TENANT_KEY_FORMAT_CODE, "Tenant key wrong format");
        }
    }

    private TenantContextUtils() {
        throw new IllegalAccessError("access not allowed");
    }

    public static String normalizeTenant(String tenantKey) {
        if (TenantContextUtils.isTenantKeyValid(tenantKey)) {
            return tenantKey;
        }
        String normalizedTenant = tenantKey.replace("-", "_");
        if (TenantContextUtils.isTenantKeyValid(normalizedTenant)) {
            return normalizedTenant;
        }
        throw new IllegalArgumentException(String.format("Tenant %s cannot be normalized.", tenantKey));
    }
}

