/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.tenant;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class TenantKey {
    public static final String SUPER_TENANT_KEY_VALUE = "xm";
    public static final TenantKey SUPER = TenantKey.valueOf("xm");
    private final String value;

    public TenantKey(String value) {
        this.value = Objects.requireNonNull(value, "value can't be null");
    }

    public static TenantKey valueOf(String tenantKey) {
        return new TenantKey(tenantKey);
    }

    public String getValue() {
        return this.value;
    }

    public boolean isSuperTenant() {
        return SUPER_TENANT_KEY_VALUE.equalsIgnoreCase(this.getValue());
    }

    public String toString() {
        return "value = " + this.value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TenantKey) {
            TenantKey other = (TenantKey)TenantKey.class.cast(obj);
            return StringUtils.equalsIgnoreCase((CharSequence)this.value, (CharSequence)other.value);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(StringUtils.upperCase((String)this.value));
    }
}

