/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.tenant.internal;

import com.icthh.xm.commons.tenant.internal.TenantContextDataHolder;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadLocalAccessorRegistryInterceptor {
    private static final Logger log = LoggerFactory.getLogger(ThreadLocalAccessorRegistryInterceptor.class);

    static void register(String key, ThreadLocal<TenantContextDataHolder> threadLocal) {
        try {
            Class<?> contextRegistry = Class.forName("io.micrometer.context.ContextRegistry");
            Method getInstance = contextRegistry.getMethod("getInstance", new Class[0]);
            Method registerThreadLocalAccessor = contextRegistry.getMethod("registerThreadLocalAccessor", String.class, ThreadLocal.class);
            Object instance = getInstance.invoke(null, new Object[0]);
            registerThreadLocalAccessor.invoke(instance, key, threadLocal);
            log.info("Successfully registered ThreadLocal in micrometer ContextRegistry by key '{}'", (Object)key);
        }
        catch (ClassNotFoundException | LinkageError | NoSuchMethodException ignored) {
            log.error("Unexpected reflective exception while registering ThreadLocal in micrometer ContextRegistry: {}", (Object)ignored.getMessage());
        }
        catch (Throwable err) {
            log.error("Unexpected exception while registering ThreadLocal in micrometer ContextRegistry. The feature is considered disabled due to this:", err);
        }
    }
}

