/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.tenant.internal;

import com.icthh.xm.commons.tenant.PrivilegedTenantContext;
import com.icthh.xm.commons.tenant.Tenant;
import com.icthh.xm.commons.tenant.TenantContext;
import com.icthh.xm.commons.tenant.TenantContextUtils;
import com.icthh.xm.commons.tenant.TenantKey;
import com.icthh.xm.commons.tenant.XmJvmSecurityUtils;
import com.icthh.xm.commons.tenant.internal.TenantContextDataHolder;
import com.icthh.xm.commons.tenant.internal.ThreadLocalTenantContext;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;

final class ThreadLocalPrivilegedTenantContext
implements PrivilegedTenantContext {
    private final TenantContextDataHolder tenantContextDataHolder;
    private final TenantContext tenantContextDelegate;

    ThreadLocalPrivilegedTenantContext(TenantContextDataHolder tenantContextDataHolder) {
        this.tenantContextDataHolder = tenantContextDataHolder;
        this.tenantContextDelegate = new ThreadLocalTenantContext(tenantContextDataHolder);
    }

    private TenantContextDataHolder getDataHolder() {
        return this.tenantContextDataHolder;
    }

    @Override
    public void setTenant(Tenant tenant) {
        this.getDataHolder().setTenant(tenant);
    }

    @Override
    public void destroyCurrentContext() {
        XmJvmSecurityUtils.checkSecurity();
        this.getDataHolder().destroyForCurrentThread();
    }

    @Override
    public <V> V execute(Tenant tenant, Supplier<V> supplier) {
        return TenantContextDataHolder.execute(tenant, supplier);
    }

    @Override
    public void execute(Tenant tenant, Runnable runnable) {
        TenantContextDataHolder.execute(tenant, runnable);
    }

    @Override
    public void execute(String tenant, Runnable runnable) {
        this.execute(TenantContextUtils.buildTenant(tenant.toUpperCase()), runnable);
    }

    @Override
    public <V> void execute(Tenant tenant, Consumer<V> consumer, V value) {
        TenantContextDataHolder.execute(tenant, consumer, value);
    }

    @Override
    public boolean isInitialized() {
        return this.tenantContextDelegate.isInitialized();
    }

    @Override
    public Optional<Tenant> getTenant() {
        return this.tenantContextDelegate.getTenant();
    }

    @Override
    public Optional<TenantKey> getTenantKey() {
        return this.tenantContextDelegate.getTenantKey();
    }
}

