/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.timeline;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.icthh.xm.commons.logging.util.MdcUtils;
import com.icthh.xm.commons.timeline.domain.ApiMaskConfig;
import com.icthh.xm.commons.timeline.domain.ApiMaskRule;
import com.icthh.xm.commons.timeline.util.HttpUtils;
import com.icthh.xm.commons.timeline.util.JsonUtils;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.util.AntPathMatcher;

@Component
public class TimelineEventProducer {
    private static final Logger log = LoggerFactory.getLogger(TimelineEventProducer.class);
    private static final List<String> PREFIXES = Arrays.asList("$.", "$.xmEntity.", "$.data.");
    private final KafkaTemplate<Integer, String> template;
    private final ObjectMapper mapper = new ObjectMapper();
    private final AntPathMatcher matcher = new AntPathMatcher();
    @Value(value="${spring.application.name}")
    private String appName;
    private List<ApiMaskRule> maskRules;

    public TimelineEventProducer(KafkaTemplate<Integer, String> template, ApiMaskConfig apiIgnore) {
        this.template = template;
        this.maskRules = apiIgnore != null ? apiIgnore.getMaskRules() : null;
    }

    public String createEventJson(HttpServletRequest request, HttpServletResponse response, String tenant, String userLogin, String userKey) {
        try {
            String requestBody = HttpUtils.getRequestContent(request);
            String responseBody = HttpUtils.getResponseContent(response);
            Instant startDate = Instant.ofEpochMilli(System.currentTimeMillis() - MdcUtils.getExecTimeMs());
            LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
            data.put("rid", MdcUtils.getRid());
            data.put("login", userLogin);
            data.put("userKey", userKey);
            data.put("tenant", tenant);
            data.put("msName", this.appName);
            data.put("operationName", TimelineEventProducer.getResourceName(request.getRequestURI()) + " " + TimelineEventProducer.getOperation(request.getMethod()));
            data.put("operationUrl", request.getRequestURI());
            data.put("operationQueryString", request.getQueryString());
            data.put("startDate", startDate.toString());
            data.put("httpMethod", request.getMethod());
            data.put("requestBody", this.maskContent(requestBody, request.getRequestURI(), true, request.getMethod()));
            data.put("requestLength", requestBody.length());
            data.put("responseBody", this.maskContent(responseBody, request.getRequestURI(), false, request.getMethod()));
            data.put("responseLength", responseBody.length());
            data.put("requestHeaders", TimelineEventProducer.getRequestHeaders(request));
            data.put("responseHeaders", TimelineEventProducer.getResponseHeaders(response));
            data.put("httpStatusCode", response.getStatus());
            data.put("channelType", "HTTP");
            data.put("entityId", JsonUtils.findField(responseBody, "id", PREFIXES));
            data.put("entityKey", JsonUtils.findField(responseBody, "key", PREFIXES));
            data.put("entityTypeKey", JsonUtils.findField(responseBody, "typeKey", PREFIXES));
            data.put("execTime", MdcUtils.getExecTimeMs());
            return this.mapper.writeValueAsString(data);
        }
        catch (Exception e) {
            log.warn("Error creating timeline event", (Throwable)e);
            return null;
        }
    }

    @Async
    public void send(String topic, String content) {
        try {
            if (!StringUtils.isBlank((CharSequence)content)) {
                log.debug("Sending kafka event with data {} to topic {}", (Object)content, (Object)topic);
                this.template.send(topic, (Object)content);
            }
        }
        catch (Exception e) {
            log.error("Error send timeline event", (Throwable)e);
            throw e;
        }
    }

    private static Map<String, Object> getRequestHeaders(HttpServletRequest request) {
        LinkedHashMap<String, Object> headers = new LinkedHashMap<String, Object>();
        Set<String> excludedHeaders = TimelineEventProducer.getExcludeHeaders();
        Enumeration names = request.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (excludedHeaders.contains(name.toLowerCase())) continue;
            headers.put(name.toLowerCase(), TimelineEventProducer.getHeaderValue(request, name));
        }
        return headers;
    }

    private static Set<String> getExcludeHeaders() {
        HashSet<String> excludedHeaders = new HashSet<String>();
        excludedHeaders.add("cookie");
        excludedHeaders.add("authorization");
        return excludedHeaders;
    }

    private static Object getHeaderValue(HttpServletRequest request, String name) {
        ArrayList value = Collections.list(request.getHeaders(name));
        if (value.size() == 1) {
            return value.get(0);
        }
        if (value.isEmpty()) {
            return "";
        }
        return value;
    }

    private static Map<String, String> getResponseHeaders(HttpServletResponse response) {
        LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
        for (String header : response.getHeaderNames()) {
            String value = response.getHeader(header);
            headers.put(header.toLowerCase(), value);
        }
        headers.remove("set-cookie");
        return headers;
    }

    private static String getOperation(String method) {
        switch (method) {
            case "GET": {
                return "viewed";
            }
            case "POST": {
                return "created";
            }
            case "PUT": {
                return "changed";
            }
            case "DELETE": {
                return "deleted";
            }
        }
        return "";
    }

    private static String getResourceName(String path) {
        String name = StringUtils.removeStart((String)path, (String)"/api/");
        if (StringUtils.startsWith((CharSequence)name, (CharSequence)"_search")) {
            name = StringUtils.substringAfter((String)name, (String)"/");
        }
        return (String)StringUtils.defaultIfBlank((CharSequence)StringUtils.substringBefore((String)name, (String)"/"), (CharSequence)"unknown");
    }

    private String maskContent(String content, String uri, boolean request, String httpMethod) {
        if (CollectionUtils.isEmpty(this.maskRules) || StringUtils.isBlank((CharSequence)content)) {
            return content;
        }
        return this.maskRules.stream().filter(rule -> (request && rule.isMaskRequest() || !request && rule.isMaskResponse()) && this.matcher.match(rule.getEndpointToMask(), uri) && rule.getHttpMethod().stream().anyMatch(method -> StringUtils.equalsIgnoreCase((CharSequence)method, (CharSequence)httpMethod))).map(rule -> TimelineEventProducer.applyMask(content, rule)).findAny().orElse(content);
    }

    private static String applyMask(String content, ApiMaskRule rule) {
        String maskedContent = content;
        for (String path : rule.getPathToMask()) {
            try {
                maskedContent = JsonPath.parse((String)maskedContent).set(path, (Object)rule.getMask(), new Predicate[0]).jsonString();
            }
            catch (PathNotFoundException e) {
                log.debug("Path {} not found, when masking content data", (Object)path);
            }
            catch (Exception e) {
                log.warn("Failed to mask content data", (Throwable)e);
            }
        }
        return maskedContent;
    }
}

