/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.timeline.config;

import com.icthh.xm.commons.timeline.TimelineEventProducer;
import com.icthh.xm.commons.timeline.util.HttpUtils;
import com.icthh.xm.commons.timeline.util.JsonUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.authentication.OAuth2AuthenticationDetails;
import org.springframework.stereotype.Component;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@Component
public class TimelineInterceptor
extends HandlerInterceptorAdapter {
    private static final Logger log = LoggerFactory.getLogger(TimelineInterceptor.class);
    private static final String HEADER_TENANT = "x-tenant";
    private static final String AUTH_TENANT_KEY = "tenant";
    private static final String AUTH_USER_KEY = "user_key";
    private static final String TYPE_KEY = "typeKey";
    private static final List<String> PREFIXES = Arrays.asList("$.", "$.xmEntity.");
    private final AntPathMatcher matcher = new AntPathMatcher();
    private final TimelineEventProducer eventProducer;
    private final List<String> ignoredPatterns;
    private final List<String> ignoredHttpMethods;
    private final List<String> ignoredTypeKeys;

    public TimelineInterceptor(TimelineEventProducer eventProducer, @Value(value="${application.tenant-ignored-path-list:true}") List<String> ignoredPatterns, @Value(value="${application.timeline-ignored-http-methods:#{T(java.util.Collections).emptyList()}}") List<String> ignoredHttpMethods, @Value(value="${application.timeline-ignored-type-keys:#{T(java.util.Collections).emptyList()}}") List<String> ignoredTypeKeys) {
        this.eventProducer = eventProducer;
        this.ignoredPatterns = ignoredPatterns;
        this.ignoredHttpMethods = ignoredHttpMethods;
        this.ignoredTypeKeys = ignoredTypeKeys;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        if (this.isIgnoredRequest(request, response)) {
            return;
        }
        OAuth2Authentication auth = TimelineInterceptor.getAuthentication();
        if (auth == null) {
            String tenant = request.getHeader(HEADER_TENANT);
            this.produceTimeline(request, response, tenant, null, null);
        } else {
            Map<String, String> details = this.getUserDetails(auth);
            String tenant = details.getOrDefault(AUTH_TENANT_KEY, "");
            String userKey = details.getOrDefault(AUTH_USER_KEY, "");
            String userLogin = (String)auth.getPrincipal();
            this.produceTimeline(request, response, tenant, userLogin, userKey);
        }
    }

    private Map<String, String> getUserDetails(OAuth2Authentication auth) {
        Map details = null;
        if (auth.getDetails() != null) {
            details = (Map)Map.class.cast(((OAuth2AuthenticationDetails)OAuth2AuthenticationDetails.class.cast(auth.getDetails())).getDecodedDetails());
        }
        details = (Map)ObjectUtils.firstNonNull((Object[])new Map[]{details, new HashMap()});
        return details;
    }

    private static OAuth2Authentication getAuthentication() {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth instanceof OAuth2Authentication) {
            return (OAuth2Authentication)SecurityContextHolder.getContext().getAuthentication();
        }
        return null;
    }

    private boolean isIgnoredRequest(HttpServletRequest request, HttpServletResponse response) {
        String path = request.getServletPath();
        String httpMethod = request.getMethod();
        if (CollectionUtils.isNotEmpty(this.ignoredHttpMethods) && this.ignoredHttpMethods.contains(httpMethod)) {
            return true;
        }
        if (this.ignoredPatterns != null && path != null) {
            for (String pattern : this.ignoredPatterns) {
                if (!this.matcher.match(pattern, path)) continue;
                return true;
            }
        }
        if (CollectionUtils.isEmpty(this.ignoredTypeKeys)) {
            return false;
        }
        String responseBody = HttpUtils.getResponseContent(response);
        Object typeKey = JsonUtils.findField(responseBody, TYPE_KEY, PREFIXES);
        return this.ignoredTypeKeys.contains(typeKey);
    }

    private void produceTimeline(HttpServletRequest request, HttpServletResponse response, String tenant, String userLogin, String userKey) {
        String content = this.eventProducer.createEventJson(request, response, tenant, userLogin, userKey);
        this.eventProducer.send(tenant, content);
    }
}

