/*
 * Decompiled with CFR 0.152.
 */
package com.icthh.xm.commons.timeline.util;

import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.ContentCachingRequestWrapper;
import org.springframework.web.util.ContentCachingResponseWrapper;

public final class HttpUtils {
    private static final Logger log = LoggerFactory.getLogger(HttpUtils.class);

    public static String getRequestContent(HttpServletRequest request) {
        HttpServletRequestWrapper httpServletRequestWrapper;
        ServletRequest servletRequest;
        if (request instanceof ContentCachingRequestWrapper) {
            ContentCachingRequestWrapper contentCachingRequestWrapper = (ContentCachingRequestWrapper)request;
            return new String(contentCachingRequestWrapper.getContentAsByteArray());
        }
        if (request instanceof HttpServletRequestWrapper && (servletRequest = (httpServletRequestWrapper = (HttpServletRequestWrapper)request).getRequest()) instanceof ContentCachingRequestWrapper) {
            ContentCachingRequestWrapper contentCachingRequestWrapper = (ContentCachingRequestWrapper)servletRequest;
            return new String(contentCachingRequestWrapper.getContentAsByteArray());
        }
        log.warn("Empty request content because of unsupported request class {}", (Object)request.getClass());
        return "";
    }

    public static String getResponseContent(HttpServletResponse response) {
        HttpServletResponseWrapper httpServletResponseWrapper;
        ServletResponse servletResponse;
        if (response instanceof ContentCachingResponseWrapper) {
            ContentCachingResponseWrapper cachingResponseWrapper = (ContentCachingResponseWrapper)response;
            return new String(cachingResponseWrapper.getContentAsByteArray());
        }
        if (response instanceof HttpServletResponseWrapper && (servletResponse = (httpServletResponseWrapper = (HttpServletResponseWrapper)response).getResponse()) instanceof ContentCachingResponseWrapper) {
            ContentCachingResponseWrapper contentCachingResponseWrapper = (ContentCachingResponseWrapper)servletResponse;
            return new String(contentCachingResponseWrapper.getContentAsByteArray());
        }
        log.warn("Empty response content because of unsupported response class {}", (Object)response.getClass());
        return "";
    }

    private HttpUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

