/*
 * Decompiled with CFR 0.152.
 */
package com.ideaheap.barelyfunctional.data;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;

public class BfLists {
    public static <T> List<T> list(T ... elements) {
        return ImmutableList.copyOf((Object[])elements);
    }

    public static <T> List<T> merge(Collection<T> ... lists) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Collection<T> list : lists) {
            builder.addAll(list);
        }
        return builder.build();
    }

    public static <T> List<T> assoc(List<T> list, int idx, T val) {
        return ImmutableList.builder().addAll(list.subList(0, idx)).add(val).addAll(list.subList(idx + 1, list.size())).build();
    }

    public static <T> List<T> remove(List<T> list, int idx) {
        return ImmutableList.builder().addAll(list.subList(0, idx)).addAll(list.subList(idx + 1, list.size())).build();
    }

    public static <T> List<T> insert(List<T> list, int idx, T val) {
        return ImmutableList.builder().addAll(list.subList(0, idx)).add(val).addAll(list.subList(idx, list.size())).build();
    }

    public static <T> List<T> push(List<T> list, T ... end) {
        return ImmutableList.builder().addAll(list).add((Object[])end).build();
    }

    public static <T> List<T> unshift(List<T> list, T ... head) {
        return ImmutableList.builder().add((Object[])head).addAll(list).build();
    }
}

