/*
 * Decompiled with CFR 0.152.
 */
package com.ideaheap.barelyfunctional.data;

import com.google.common.collect.ImmutableMap;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;

public class BfMaps {
    public static <K, V> Map<K, V> merge(Map<K, V> ... maps) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map<K, V> map : maps) {
            builder.putAll(map);
        }
        return builder.build();
    }

    public static <K, V> Map<K, V> assoc(Map<K, V> map, Map.Entry<K, V> ... entries) {
        HashMap<K, V> comboMap = new HashMap<K, V>();
        comboMap.putAll(map);
        for (Map.Entry<K, V> entry : entries) {
            comboMap.put(entry.getKey(), entry.getValue());
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.putAll(comboMap);
        return builder.build();
    }

    public static <K, V> Map<K, V> assoc(Map<K, V> map, Map<K, V> upsertMap) {
        HashMap<K, V> comboMap = new HashMap<K, V>();
        comboMap.putAll(map);
        for (Map.Entry<K, V> entry : upsertMap.entrySet()) {
            comboMap.put(entry.getKey(), entry.getValue());
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.putAll(comboMap);
        return builder.build();
    }

    public static <K, V> Map<K, V> dissoc(Map<K, V> map, K ... keys) {
        HashMap<K, V> comboMap = new HashMap<K, V>();
        comboMap.putAll(map);
        for (K key : keys) {
            if (!comboMap.containsKey(key)) continue;
            comboMap.remove(key);
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.putAll(comboMap);
        return builder.build();
    }

    public static <K, V> Map<K, V> map(Map.Entry<K, V> ... entries) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<K, V> entry : entries) {
            builder.put(entry);
        }
        return builder.build();
    }

    public static <K, V> Map<K, V> assoc(Map<K, V> map, K key, V val) {
        return BfMaps.assoc(map, BfMaps.e(key, val));
    }

    public static <K, V> Map.Entry<K, V> e(K key, V val) {
        return new AbstractMap.SimpleImmutableEntry<K, V>(key, val);
    }
}

