/*
 * Decompiled with CFR 0.152.
 */
package com.ideaheap.barelyfunctional.data;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class BfSets {
    public static <T> Set<T> set(T ... values) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object[])values);
        return builder.build();
    }

    public static <T> Set<T> assoc(Set<T> set, T ... vals) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.addAll(set);
        builder.add((Object[])vals);
        return builder.build();
    }

    public static <T> Set<T> dissoc(Set<T> set, T ... vals) {
        return BfSets.not(set, BfSets.set(vals));
    }

    public static <T> Set<T> union(Set<T> ... sets) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Set<T> set : sets) {
            builder.addAll(set);
        }
        return builder.build();
    }

    public static <T> Set<T> intersection(Set<T> ... sets) {
        return (Set)Arrays.asList(sets).stream().reduce((set1, set2) -> Sets.intersection((Set)set1, (Set)set2)).get();
    }

    public static <T> Set<T> xor(Set<T> ... sets) {
        return (Set)Arrays.asList(sets).stream().reduce((set1, set2) -> BfSets.not(Sets.union((Set)set1, (Set)set2), new Set[]{Sets.intersection((Set)set1, (Set)set2)})).get();
    }

    public static <T> Set<T> not(Set<T> set, Set<T> ... removals) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        HashSet<T> updateSet = new HashSet<T>();
        updateSet.addAll(set);
        for (Set<T> removal : removals) {
            updateSet.removeAll(removal);
        }
        builder.addAll(updateSet);
        return builder.build();
    }
}

