/*
 * Decompiled with CFR 0.152.
 */
package com.ideaheap.barelyfunctional.functions;

import com.google.common.base.Optional;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.ideaheap.barelyfunctional.data.BfTuples;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.javatuples.Pair;

public class Memoizer {
    private final CacheBuilder builder;

    public Memoizer(CacheBuilder builder) {
        this.builder = builder;
    }

    public <T, R> Function<T, R> memoize(Function<T, R> function) {
        Cache entries = this.builder.build();
        return t -> {
            Optional ifPresent = (Optional)entries.getIfPresent(t);
            if (ifPresent == null) {
                Object result = function.apply(t);
                entries.put(t, (Object)Optional.fromNullable(result));
                return result;
            }
            return ifPresent.orNull();
        };
    }

    public <T, U, R> BiFunction<T, U, R> memoize(BiFunction<T, U, R> biFunction) {
        Function<Pair, Object> memo = this.memoize((T pair) -> biFunction.apply(pair.getValue0(), pair.getValue1()));
        return (t, u) -> memo.apply(BfTuples.tuple(t, u));
    }
}

