/*
 * Decompiled with CFR 0.152.
 */
package com.identityx.clientSDK;

import com.identityx.auth.impl.DefaultSSLConnectionSocketFactoryProvider;
import com.identityx.auth.impl.Proxy;
import com.identityx.clientSDK.base.BaseRepoFactory;
import com.identityx.clientSDK.base.RestClient;
import com.identityx.clientSDK.def.ICredentialsProvider;
import com.identityx.clientSDK.exceptions.IdxRestException;
import com.identityx.clientSDK.repositories.AuditRepository;
import com.identityx.clientSDK.repositories.ConfigurationRepository;
import com.identityx.clientSDK.repositories.RoleRepository;
import com.identityx.clientSDK.repositories.StatisticRepository;
import com.identityx.clientSDK.repositories.SystemAuthenticatorTypeRepository;
import com.identityx.clientSDK.repositories.TenantRepository;
import com.identityx.clientSDK.repositories.TokenRepository;
import java.security.KeyStore;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;

public class SystemRepoFactory
extends BaseRepoFactory {
    private AuditRepository auditRepo = new AuditRepository();
    private SystemAuthenticatorTypeRepository authenticatorTypeRepo = new SystemAuthenticatorTypeRepository();
    private RoleRepository roleRepo = new RoleRepository();
    private TenantRepository tenantRepo = new TenantRepository();
    private TokenRepository tokenRepo = new TokenRepository();
    private ConfigurationRepository configRepo = new ConfigurationRepository();
    private StatisticRepository statisticRepo = new StatisticRepository();

    protected SystemRepoFactory() {
    }

    public SystemRepoFactory(ICredentialsProvider credentialProvider) throws IdxRestException {
        if (credentialProvider == null) {
            throw new IllegalArgumentException("Missing credentialProvider");
        }
        this.init(credentialProvider.getApiKey(), credentialProvider.getResponseApiKey(), credentialProvider.getBaseUrl(), null, null, true);
    }

    public SystemRepoFactory(ICredentialsProvider credentialProvider, Proxy proxy) throws IdxRestException {
        if (credentialProvider == null) {
            throw new IllegalArgumentException("Missing credentialProvider");
        }
        this.init(credentialProvider.getApiKey(), credentialProvider.getResponseApiKey(), credentialProvider.getBaseUrl(), proxy, null, true);
    }

    public SystemRepoFactory(ICredentialsProvider credentialProvider, Proxy proxy, SSLConnectionSocketFactory sslCSF) throws IdxRestException {
        if (credentialProvider == null) {
            throw new IllegalArgumentException("Missing credentialProvider");
        }
        this.init(credentialProvider.getApiKey(), credentialProvider.getResponseApiKey(), credentialProvider.getBaseUrl(), proxy, sslCSF, true);
    }

    @Override
    protected void initRepos(RestClient restClient, String baseUrl) {
        this.setRestClient(restClient);
        this.auditRepo.init(restClient, baseUrl);
        this.authenticatorTypeRepo.init(restClient, baseUrl);
        this.roleRepo.init(restClient, baseUrl);
        this.tenantRepo.init(restClient, baseUrl);
        this.tokenRepo.init(restClient, baseUrl);
        this.configRepo.init(restClient, baseUrl);
        this.statisticRepo.init(restClient, baseUrl);
    }

    public SystemRepoFactory(ICredentialsProvider credentialProvider, KeyStore trustStore) throws IdxRestException {
        SSLConnectionSocketFactory sslCSF = null;
        if (credentialProvider == null) {
            throw new IllegalArgumentException("Missing credentialProvider");
        }
        DefaultSSLConnectionSocketFactoryProvider sslCSFP = new DefaultSSLConnectionSocketFactoryProvider();
        sslCSF = sslCSFP.get(trustStore, null);
        this.init(credentialProvider.getApiKey(), credentialProvider.getResponseApiKey(), credentialProvider.getBaseUrl(), null, sslCSF, true);
    }

    public AuditRepository getAuditRepo() {
        return this.auditRepo;
    }

    public SystemAuthenticatorTypeRepository getAuthenticatorTypeRepo() {
        return this.authenticatorTypeRepo;
    }

    public RoleRepository getRoleRepo() {
        return this.roleRepo;
    }

    public TenantRepository getTenantRepo() {
        return this.tenantRepo;
    }

    public TokenRepository getTokenRepo() {
        return this.tokenRepo;
    }

    public ConfigurationRepository getConfigRepo() {
        return this.configRepo;
    }

    public StatisticRepository getStatisticRepo() {
        return this.statisticRepo;
    }

    public static class SystemRepoFactoryBuilder
    extends BaseRepoFactory.RepoFactoryBuilder {
        @Override
        public SystemRepoFactoryBuilder setRestClient(RestClient restClient) {
            super.setRestClient(restClient);
            return this;
        }

        @Override
        public SystemRepoFactoryBuilder setCredentialsProvider(ICredentialsProvider credentialProvider) {
            super.setCredentialsProvider(credentialProvider);
            return this;
        }

        @Override
        public SystemRepoFactoryBuilder setCreateBrowserSession(boolean createBrowserSession) {
            super.setCreateBrowserSession(createBrowserSession);
            return this;
        }

        @Override
        public SystemRepoFactoryBuilder setBaseUrl(String baseUrl) {
            super.setBaseUrl(baseUrl);
            return this;
        }

        @Override
        public SystemRepoFactory build() throws IdxRestException {
            SystemRepoFactory systemRepoFactory = new SystemRepoFactory();
            return (SystemRepoFactory)super.build(systemRepoFactory);
        }
    }
}

