/*
 * Decompiled with CFR 0.152.
 */
package com.identityx.clientSDK;

import com.identityx.auth.impl.DefaultSSLConnectionSocketFactoryProvider;
import com.identityx.auth.impl.Proxy;
import com.identityx.clientSDK.base.BaseRepoFactory;
import com.identityx.clientSDK.base.RestClient;
import com.identityx.clientSDK.def.ICredentialsProvider;
import com.identityx.clientSDK.exceptions.IdxRestException;
import com.identityx.clientSDK.repositories.ApplicationRepository;
import com.identityx.clientSDK.repositories.AuditRepository;
import com.identityx.clientSDK.repositories.AuthenticationRequestRepository;
import com.identityx.clientSDK.repositories.AuthenticatorRepository;
import com.identityx.clientSDK.repositories.AuthenticatorTypeRepository;
import com.identityx.clientSDK.repositories.ConfigurationRepository;
import com.identityx.clientSDK.repositories.FidoAAIDStatisticRepository;
import com.identityx.clientSDK.repositories.MetadataRepository;
import com.identityx.clientSDK.repositories.PolicyRepository;
import com.identityx.clientSDK.repositories.RegistrationChallengeRepository;
import com.identityx.clientSDK.repositories.RegistrationRepository;
import com.identityx.clientSDK.repositories.RoleRepository;
import com.identityx.clientSDK.repositories.SponsorshipRepository;
import com.identityx.clientSDK.repositories.StatisticRepository;
import com.identityx.clientSDK.repositories.TokenRepository;
import com.identityx.clientSDK.repositories.UserRepository;
import java.security.KeyStore;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;

public class TenantRepoFactory
extends BaseRepoFactory {
    private ApplicationRepository applicationRepo = new ApplicationRepository();
    private AuditRepository auditRepo = new AuditRepository();
    private AuthenticationRequestRepository authenticationRequestRepo = new AuthenticationRequestRepository();
    private AuthenticatorRepository authenticatorRepo = new AuthenticatorRepository();
    private PolicyRepository policyRepo = new PolicyRepository();
    private RegistrationRepository registrationRepo = new RegistrationRepository();
    private RegistrationChallengeRepository registrationChallengeRepo = new RegistrationChallengeRepository();
    private RoleRepository roleRepo = new RoleRepository();
    private SponsorshipRepository sponsorshipRepo = new SponsorshipRepository();
    private AuthenticatorTypeRepository authenticatorTypeRepo = new AuthenticatorTypeRepository();
    private TokenRepository tokenRepo = new TokenRepository();
    private UserRepository userRepo = new UserRepository();
    private ConfigurationRepository configRepo = new ConfigurationRepository();
    private StatisticRepository statisticRepo = new StatisticRepository();
    private FidoAAIDStatisticRepository fidoAAIDStatisticRepo = new FidoAAIDStatisticRepository();
    private MetadataRepository metadataRepo = new MetadataRepository();

    protected TenantRepoFactory() {
    }

    public TenantRepoFactory(ICredentialsProvider credentialProvider) throws IdxRestException {
        if (credentialProvider == null) {
            throw new IllegalArgumentException("Missing credentialProvider");
        }
        this.init(credentialProvider.getApiKey(), credentialProvider.getResponseApiKey(), credentialProvider.getBaseUrl(), null, null, true);
    }

    public TenantRepoFactory(ICredentialsProvider credentialProvider, Proxy proxy) throws IdxRestException {
        if (credentialProvider == null) {
            throw new IllegalArgumentException("Missing credentialProvider");
        }
        this.init(credentialProvider.getApiKey(), credentialProvider.getResponseApiKey(), credentialProvider.getBaseUrl(), proxy, null, true);
    }

    public TenantRepoFactory(ICredentialsProvider credentialProvider, Proxy proxy, SSLConnectionSocketFactory sslCSF) throws IdxRestException {
        if (credentialProvider == null) {
            throw new IllegalArgumentException("Missing credentialProvider");
        }
        this.init(credentialProvider.getApiKey(), credentialProvider.getResponseApiKey(), credentialProvider.getBaseUrl(), proxy, sslCSF, true);
    }

    @Override
    protected void initRepos(RestClient restClient, String baseUrl) {
        this.setRestClient(restClient);
        this.applicationRepo.init(restClient, baseUrl);
        this.auditRepo.init(restClient, baseUrl);
        this.authenticationRequestRepo.init(restClient, baseUrl);
        this.authenticatorRepo.init(restClient, baseUrl);
        this.policyRepo.init(restClient, baseUrl);
        this.registrationRepo.init(restClient, baseUrl);
        this.registrationChallengeRepo.init(restClient, baseUrl);
        this.roleRepo.init(restClient, baseUrl);
        this.sponsorshipRepo.init(restClient, baseUrl);
        this.authenticatorTypeRepo.init(restClient, baseUrl);
        this.tokenRepo.init(restClient, baseUrl);
        this.userRepo.init(restClient, baseUrl);
        this.configRepo.init(restClient, baseUrl);
        this.statisticRepo.init(restClient, baseUrl);
        this.fidoAAIDStatisticRepo.init(restClient, baseUrl);
        this.metadataRepo.init(restClient, baseUrl);
    }

    public TenantRepoFactory(ICredentialsProvider credentialProvider, KeyStore trustStore) throws IdxRestException {
        SSLConnectionSocketFactory sslCSF = null;
        if (credentialProvider == null) {
            throw new IllegalArgumentException("Missing credentialProvider");
        }
        DefaultSSLConnectionSocketFactoryProvider sslCSFP = new DefaultSSLConnectionSocketFactoryProvider();
        sslCSF = sslCSFP.get(trustStore, null);
        this.init(credentialProvider.getApiKey(), credentialProvider.getResponseApiKey(), credentialProvider.getBaseUrl(), null, sslCSF, true);
    }

    public ApplicationRepository getApplicationRepo() {
        return this.applicationRepo;
    }

    public AuditRepository getAuditRepo() {
        return this.auditRepo;
    }

    public AuthenticationRequestRepository getAuthenticationRequestRepo() {
        return this.authenticationRequestRepo;
    }

    public AuthenticatorRepository getAuthenticatorRepo() {
        return this.authenticatorRepo;
    }

    public PolicyRepository getPolicyRepo() {
        return this.policyRepo;
    }

    public RegistrationRepository getRegistrationRepo() {
        return this.registrationRepo;
    }

    public RegistrationChallengeRepository getRegistrationChallengeRepo() {
        return this.registrationChallengeRepo;
    }

    public RoleRepository getRoleRepo() {
        return this.roleRepo;
    }

    public SponsorshipRepository getSponsorshipRepo() {
        return this.sponsorshipRepo;
    }

    public AuthenticatorTypeRepository getAuthenticatorTypeRepo() {
        return this.authenticatorTypeRepo;
    }

    public TokenRepository getTokenRepo() {
        return this.tokenRepo;
    }

    public UserRepository getUserRepo() {
        return this.userRepo;
    }

    public ConfigurationRepository getConfigRepo() {
        return this.configRepo;
    }

    public StatisticRepository getStatisticRepo() {
        return this.statisticRepo;
    }

    public FidoAAIDStatisticRepository getFidoAAIDStatisticRepo() {
        return this.fidoAAIDStatisticRepo;
    }

    public MetadataRepository getMetadataRepo() {
        return this.metadataRepo;
    }

    public static class TenantRepoFactoryBuilder
    extends BaseRepoFactory.RepoFactoryBuilder {
        @Override
        public TenantRepoFactoryBuilder setRestClient(RestClient restClient) {
            super.setRestClient(restClient);
            return this;
        }

        @Override
        public TenantRepoFactoryBuilder setCredentialsProvider(ICredentialsProvider credentialProvider) {
            super.setCredentialsProvider(credentialProvider);
            return this;
        }

        @Override
        public TenantRepoFactoryBuilder setCreateBrowserSession(boolean createBrowserSession) {
            super.setCreateBrowserSession(createBrowserSession);
            return this;
        }

        @Override
        public TenantRepoFactoryBuilder setBaseUrl(String baseUrl) {
            super.setBaseUrl(baseUrl);
            return this;
        }

        @Override
        public TenantRepoFactory build() throws IdxRestException {
            TenantRepoFactory tenantRepoFactory = new TenantRepoFactory();
            return (TenantRepoFactory)super.build(tenantRepoFactory);
        }
    }
}

