/*
 * Decompiled with CFR 0.152.
 */
package com.identityx.clientSDK.base;

import com.daon.identityx.rest.model.pojo.Token;
import com.identityx.auth.client.HttpClientRequestExecutor;
import com.identityx.auth.def.IApiKey;
import com.identityx.auth.def.IRequestExecutor;
import com.identityx.auth.impl.AuthenticationScheme;
import com.identityx.auth.impl.Proxy;
import com.identityx.auth.impl.keys.ADCredentialsKey;
import com.identityx.auth.impl.keys.SharedSecretApiKey;
import com.identityx.clientSDK.base.KeyHelper;
import com.identityx.clientSDK.base.RestClient;
import com.identityx.clientSDK.def.ICredentialsProvider;
import com.identityx.clientSDK.exceptions.IdxRestException;
import com.identityx.clientSDK.repositories.SessionTokenRepository;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;

public abstract class BaseRepoFactory {
    private String cookie = null;
    protected SessionTokenRepository sessionTokenRepo = new SessionTokenRepository();
    protected String defaultCn = "daon.com";
    private RestClient restClient = new RestClient();

    public RestClient getRestClient() {
        return this.restClient;
    }

    public void setRestClient(RestClient restClient) {
        this.restClient = restClient;
    }

    protected SharedSecretApiKey getSessionKey() throws IdxRestException {
        SharedSecretApiKey newApiKey = null;
        try {
            KeyHelper keyHelper = new KeyHelper();
            Token newToken = new Token();
            newToken.setPublicKey(keyHelper.getPublicKeyForTokenRequest(this.defaultCn));
            newToken = this.sessionTokenRepo.create(newToken);
            newApiKey = keyHelper.createFromToken(newToken);
            this.setCookie("idx=" + newToken.getCookie());
        }
        catch (IOException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new IdxRestException("Failed to get a session key", e);
        }
        return newApiKey;
    }

    public String getCookie() {
        return this.cookie;
    }

    public void setCookie(String cookie) {
        this.cookie = cookie;
    }

    public SessionTokenRepository getSessionTokenRepo() {
        return this.sessionTokenRepo;
    }

    protected abstract void initRepos(RestClient var1, String var2);

    protected SharedSecretApiKey initSessionAccessToken(IApiKey apiKey, String baseUrl, Proxy proxy, SSLConnectionSocketFactory sslCSF) throws IdxRestException {
        SharedSecretApiKey ssKey = null;
        if (apiKey instanceof ADCredentialsKey) {
            this.getSessionTokenRepo().getRestClient().setProxy(proxy);
            this.getSessionTokenRepo().init(apiKey, true, baseUrl, this.getCookie(), sslCSF);
            ssKey = this.getSessionKey();
        } else if (apiKey instanceof SharedSecretApiKey) {
            ssKey = (SharedSecretApiKey)apiKey;
        } else {
            throw new IllegalArgumentException("apiKey");
        }
        return ssKey;
    }

    protected void init(IApiKey apiKey, IApiKey responseApiKey, String baseUrl, Proxy proxy, SSLConnectionSocketFactory sslCSF, boolean ignoreCookies) throws IdxRestException {
        IApiKey ssKey = apiKey;
        if (apiKey instanceof ADCredentialsKey) {
            ssKey = this.initSessionAccessToken(apiKey, baseUrl, proxy, sslCSF);
        }
        this.initRestClient(ssKey, responseApiKey, proxy, sslCSF, ignoreCookies);
        this.initRepos(this.getRestClient(), baseUrl);
    }

    protected RestClient initRestClient(IApiKey apiKey, IApiKey responseApiKey, Proxy proxy, SSLConnectionSocketFactory sslCSF, boolean ignoreCookies) {
        this.restClient.setProxy(proxy);
        this.restClient.init(apiKey, responseApiKey, sslCSF, ignoreCookies);
        this.restClient.setCookie(this.getCookie());
        return this.restClient;
    }

    public static abstract class RepoFactoryBuilder {
        private String baseUrl;
        private RestClient restClient;
        private boolean createBrowserSession = false;
        private ICredentialsProvider credentialProvider;
        private boolean ignoreCookies = true;

        public RepoFactoryBuilder setRestClient(RestClient restClient) {
            this.restClient = restClient;
            return this;
        }

        public RepoFactoryBuilder setCredentialsProvider(ICredentialsProvider credentialProvider) {
            this.credentialProvider = credentialProvider;
            return this;
        }

        public RepoFactoryBuilder setCreateBrowserSession(boolean createBrowserSession) {
            this.createBrowserSession = createBrowserSession;
            return this;
        }

        public RepoFactoryBuilder setIgnoreCookies(boolean ignoreCookies) {
            this.ignoreCookies = ignoreCookies;
            return this;
        }

        public RepoFactoryBuilder setBaseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        protected abstract BaseRepoFactory build() throws IdxRestException;

        protected BaseRepoFactory build(BaseRepoFactory repoFactory) throws IdxRestException {
            if (this.createBrowserSession && !this.ignoreCookies) {
                throw new IllegalArgumentException("Cannot support cookies if managing a browser session");
            }
            if (this.credentialProvider == null && this.restClient == null) {
                throw new IllegalArgumentException("Credentials or a fully initialized rest client are required");
            }
            if (!this.createBrowserSession && this.credentialProvider != null && this.restClient != null) {
                throw new IllegalArgumentException("Both credentials and restClient are provided. Please initialize the restClient with the apiKey and provide just the restClient and the baseUrl");
            }
            if (this.credentialProvider != null && this.baseUrl != null && !this.baseUrl.isEmpty()) {
                throw new IllegalArgumentException("Providing both a credentialProvider and a baseUrl will cause confusion");
            }
            if (this.credentialProvider != null) {
                this.baseUrl = this.credentialProvider.getBaseUrl();
                IApiKey apiKey = this.credentialProvider.getApiKey();
                if (this.restClient != null) {
                    if (this.createBrowserSession) {
                        return this.buildWithBrowserSession(repoFactory, apiKey, this.baseUrl, this.restClient);
                    }
                    repoFactory.initRepos(this.restClient, this.baseUrl);
                    return repoFactory;
                }
                if (this.createBrowserSession) {
                    return this.buildWithBrowserSession(repoFactory, apiKey, this.baseUrl, null);
                }
                if (apiKey instanceof ADCredentialsKey) {
                    HttpClientRequestExecutor requestExecutor = new HttpClientRequestExecutor.HttpClientRequestExecutorBuilder().setApiKey(apiKey).setAuthenticationScheme(AuthenticationScheme.BASIC).setResponseApiKey(apiKey).build();
                    RestClient newRestClient = new RestClient.RestClientBuilder().setIgnoreCookies(this.ignoreCookies).setRequestExecutor((IRequestExecutor)requestExecutor).build();
                    repoFactory.initRepos(newRestClient, this.baseUrl);
                } else {
                    repoFactory.initRepos(this.restClient, this.baseUrl);
                }
                return repoFactory;
            }
            if (this.restClient == null || this.restClient.getRequestExecutor() == null) {
                throw new IllegalStateException("Cannot build without a restClient or restClient.requestExecutor");
            }
            if (this.baseUrl == null) {
                throw new IllegalStateException("Cannot build without a baseUrl");
            }
            if (this.createBrowserSession) {
                return this.buildWithBrowserSession(repoFactory, this.restClient.getApiKey(), this.baseUrl, this.restClient);
            }
            repoFactory.initRepos(this.restClient, this.baseUrl);
            return repoFactory;
        }

        protected BaseRepoFactory buildWithBrowserSession(BaseRepoFactory pRepoFactory, IApiKey pApiKey, String pBaseUrl, RestClient pRestClient) throws IdxRestException {
            RestClient newRestClient = null;
            RestClient sessionTokenRestClient = null;
            sessionTokenRestClient = pRestClient == null ? new RestClient.RestClientBuilder().setApiKey(pApiKey).setResponseApiKey(pApiKey).setBasicIDX(true).build() : pRestClient;
            SharedSecretApiKey newSSKey = null;
            if (pApiKey instanceof ADCredentialsKey) {
                pRepoFactory.getSessionTokenRepo().init(sessionTokenRestClient, pBaseUrl);
                newSSKey = pRepoFactory.getSessionKey();
            } else {
                pRepoFactory.getSessionTokenRepo().init(pRestClient, pBaseUrl);
                newSSKey = pRepoFactory.getSessionKey();
            }
            newRestClient = pRestClient == null ? new RestClient.RestClientBuilder().setApiKey((IApiKey)newSSKey).setCookie(pRepoFactory.getCookie()).build() : new RestClient.RestClientBuilder().setApiKey((IApiKey)newSSKey).setCookie(pRepoFactory.getCookie()).setObjectMapper(pRestClient.getObjectMapper()).setProxy(pRestClient.getProxy()).setSSLConnectionSocketFactory(pRestClient.getSSLConnectionSocketFactory()).setHeaders(pRestClient.getHeaders() != null ? pRestClient.getHeaders().clone() : null).build();
            pRepoFactory.initRepos(newRestClient, pBaseUrl);
            return pRepoFactory;
        }
    }
}

