/*
 * Decompiled with CFR 0.152.
 */
package com.identityx.clientSDK.base;

import com.daon.identityx.rest.model.pojo.Token;
import com.identityx.auth.impl.keys.SharedSecretApiKey;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Date;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.X509Extension;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.util.PrivateKeyFactory;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import org.bouncycastle.operator.bc.BcRSAContentSignerBuilder;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemWriter;

public class KeyHelper {
    private KeyPair keyPair;

    public KeyHelper() throws NoSuchAlgorithmException {
        this.GenerateKeyPair();
    }

    public String getPublicKeyForTokenRequest(String cn) throws IOException {
        String publicKey = null;
        byte[] publicBytes = this.keyPair.getPublic().getEncoded();
        try (StringWriter pemStrWriter = new StringWriter();
             PemWriter pemWriter = new PemWriter((Writer)pemStrWriter);){
            pemWriter.writeObject((PemObjectGenerator)new PemObject("PUBLIC KEY", publicBytes));
            pemWriter.flush();
            publicKey = pemStrWriter.toString();
        }
        return publicKey;
    }

    public SharedSecretApiKey createFromToken(Token token) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException {
        Cipher cipher = Cipher.getInstance("RSA/ECB/OAEPWithSHA1AndMGF1Padding");
        cipher.init(2, this.keyPair.getPrivate());
        byte[] data = Base64.decodeBase64((String)token.getEncryptedSharedKey());
        byte[] descryptedData = cipher.doFinal(data);
        SharedSecretApiKey newApiKey = new SharedSecretApiKey();
        newApiKey.setId(token.getId());
        String base64Decrypted = Base64.encodeBase64String((byte[])descryptedData);
        newApiKey.setSecret(base64Decrypted);
        return newApiKey;
    }

    protected KeyPair GenerateKeyPair() throws NoSuchAlgorithmException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        keyPairGenerator.initialize(2048);
        this.keyPair = keyPairGenerator.generateKeyPair();
        return this.keyPair;
    }

    protected Certificate generateCertificate(String cn) {
        try {
            byte[] publicKeyBytes = this.keyPair.getPublic().getEncoded();
            SubjectPublicKeyInfo subPkInfo = new SubjectPublicKeyInfo(ASN1Sequence.getInstance((Object)publicKeyBytes));
            X509v3CertificateBuilder builder = new X509v3CertificateBuilder(new X500Name("CN=" + cn), BigInteger.valueOf(new SecureRandom().nextLong()), new Date(System.currentTimeMillis() - 10000L), new Date(System.currentTimeMillis() + 86400000L), new X500Name("CN=" + cn), subPkInfo);
            builder.addExtension(X509Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(false));
            builder.addExtension(X509Extension.keyUsage, true, (ASN1Encodable)new KeyUsage(16));
            builder.addExtension(X509Extension.extendedKeyUsage, true, (ASN1Encodable)new ExtendedKeyUsage(KeyPurposeId.anyExtendedKeyUsage));
            AlgorithmIdentifier sigAlgId = new DefaultSignatureAlgorithmIdentifierFinder().find("SHA1withRSA");
            AlgorithmIdentifier digAlgId = new DefaultDigestAlgorithmIdentifierFinder().find(sigAlgId);
            AsymmetricKeyParameter privateKeyAsymKeyParam = PrivateKeyFactory.createKey((byte[])this.keyPair.getPrivate().getEncoded());
            ContentSigner sigGen = new BcRSAContentSignerBuilder(sigAlgId, digAlgId).build(privateKeyAsymKeyParam);
            X509CertificateHolder holder = builder.build(sigGen);
            Certificate result = holder.toASN1Structure();
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot generate X509 certificate", e);
        }
    }
}

