/*
 * Decompiled with CFR 0.152.
 */
package com.identityx.clientSDK.base;

import com.daon.identityx.rest.model.pojo.ActivityDefinition;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.identityx.auth.client.HttpClientRequestExecutor;
import com.identityx.auth.def.IApiKey;
import com.identityx.auth.def.IRequest;
import com.identityx.auth.def.IRequestExecutor;
import com.identityx.auth.def.IResponse;
import com.identityx.auth.impl.AuthenticationScheme;
import com.identityx.auth.impl.HttpHeaders;
import com.identityx.auth.impl.HttpMethod;
import com.identityx.auth.impl.MediaType;
import com.identityx.auth.impl.Proxy;
import com.identityx.auth.impl.QueryString;
import com.identityx.auth.impl.keys.ADCredentialsKey;
import com.identityx.auth.impl.keys.PrivateApiKey;
import com.identityx.auth.support.DefaultRequest;
import com.identityx.auth.support.RestException;
import com.identityx.clientSDK.base.Version;
import com.identityx.clientSDK.custom.ActivityDefinitionDeserializer;
import com.identityx.clientSDK.custom.ActivityDefinitionSerializer;
import com.identityx.clientSDK.exceptions.IdxRestException;
import com.identityx.clientSDK.queryHolders.QueryHolder;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;

public class RestClient {
    private IRequestExecutor requestExecutor = null;
    private ObjectMapper mapper = null;
    private IApiKey apiKey;
    private Proxy proxy = null;
    private String cookie = null;
    private SSLConnectionSocketFactory sslCSF;
    private HttpHeaders headers = new HttpHeaders();

    public ObjectMapper getObjectMapper() {
        return this.mapper;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public void setHeaders(HttpHeaders headers) {
        this.headers = headers;
    }

    public void setObjectMapper(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    protected IRequestExecutor getRequestExecutor() {
        return this.requestExecutor;
    }

    protected void setRequestExecutor(IRequestExecutor requestExecutor) {
        this.requestExecutor = requestExecutor;
    }

    public RestClient() {
        if (this.mapper == null) {
            this.mapper = new ObjectMapper();
        }
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        SimpleModule module = new SimpleModule();
        module.addDeserializer(ActivityDefinition.class, (JsonDeserializer)new ActivityDefinitionDeserializer());
        module.addSerializer(ActivityDefinition.class, (JsonSerializer)new ActivityDefinitionSerializer());
        this.mapper.registerModule((Module)module);
        this.mapper.enableDefaultTyping();
        this.headers.setContentType(MediaType.APPLICATION_JSON);
        this.headers.add("accept", "application/json");
    }

    public void init(IApiKey apiKey, SSLConnectionSocketFactory sslCSF, boolean ignoreCookies) {
        this.apiKey = apiKey;
        if (this.requestExecutor == null) {
            if (apiKey == null) {
                this.requestExecutor = new HttpClientRequestExecutor.HttpClientRequestExecutorBuilder().setIgnoreCookies(ignoreCookies).build();
            } else if (apiKey instanceof ADCredentialsKey) {
                this.requestExecutor = new HttpClientRequestExecutor(apiKey, this.proxy, AuthenticationScheme.BASIC, sslCSF, ignoreCookies);
            } else {
                if (apiKey instanceof PrivateApiKey) {
                    throw new IllegalArgumentException("Cannot use a AsymApiKey key; try initializing with the other method");
                }
                this.requestExecutor = new HttpClientRequestExecutor(apiKey, this.proxy, AuthenticationScheme.DIGEST, sslCSF, ignoreCookies);
            }
        }
    }

    public void init(IApiKey apiKey, boolean useBasiIDX, SSLConnectionSocketFactory sslCSF, boolean ignoreCookies) {
        this.apiKey = apiKey;
        if (this.requestExecutor == null) {
            if (apiKey == null) {
                this.requestExecutor = new HttpClientRequestExecutor.HttpClientRequestExecutorBuilder().setIgnoreCookies(ignoreCookies).build();
            } else if (apiKey instanceof ADCredentialsKey) {
                this.requestExecutor = useBasiIDX ? new HttpClientRequestExecutor(apiKey, this.proxy, AuthenticationScheme.BASIC_IDX, sslCSF, ignoreCookies) : new HttpClientRequestExecutor(apiKey, this.proxy, AuthenticationScheme.BASIC, sslCSF, ignoreCookies);
            } else {
                if (apiKey instanceof PrivateApiKey) {
                    throw new IllegalArgumentException("Cannot use a AsymApiKey key; try initializing with the other method");
                }
                this.requestExecutor = new HttpClientRequestExecutor(apiKey, this.proxy, AuthenticationScheme.DIGEST, sslCSF, ignoreCookies);
            }
        }
    }

    public void init(IApiKey apiKey, IApiKey serverResponseApiKey, SSLConnectionSocketFactory sslCSF, boolean ignoreCookies) {
        this.apiKey = apiKey;
        if (this.requestExecutor == null) {
            this.requestExecutor = apiKey == null ? new HttpClientRequestExecutor.HttpClientRequestExecutorBuilder().setIgnoreCookies(ignoreCookies).build() : (apiKey instanceof ADCredentialsKey ? new HttpClientRequestExecutor(apiKey, this.proxy, AuthenticationScheme.BASIC, sslCSF, ignoreCookies) : (apiKey instanceof PrivateApiKey ? new HttpClientRequestExecutor(apiKey, serverResponseApiKey, this.proxy, AuthenticationScheme.JWS, sslCSF, ignoreCookies) : new HttpClientRequestExecutor(apiKey, this.proxy, AuthenticationScheme.DIGEST, sslCSF, ignoreCookies)));
        }
    }

    public <T> T post(Object obj, String href, Class<T> responseType) throws IdxRestException {
        if (this.requestExecutor == null) {
            throw new IllegalStateException("Object not initialised");
        }
        byte[] bodyBytes = null;
        try {
            bodyBytes = this.mapper.writeValueAsBytes(obj);
        }
        catch (Exception ex) {
            throw new IdxRestException("Failed to make the REST call: before calling, failed to serialize the passed object to JSON", ex);
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(bodyBytes);
        int length = bis.available();
        DefaultRequest request = new DefaultRequest(HttpMethod.POST, href, new QueryString(), this.headers.clone(), (InputStream)bis, (long)length);
        return this.executeRequest((IRequest)request, responseType);
    }

    public <T> T get(QueryString queryString, String href, Class<T> responseType) throws IdxRestException {
        if (this.requestExecutor == null) {
            throw new IllegalStateException("Object not initialised");
        }
        DefaultRequest request = new DefaultRequest(HttpMethod.GET, href, queryString, this.headers.clone(), null, 0L);
        return this.executeRequest((IRequest)request, responseType);
    }

    public <T> T delete(String href, Class<T> responseType) throws IdxRestException {
        if (this.requestExecutor == null) {
            throw new IllegalStateException("Object not initialised");
        }
        DefaultRequest request = new DefaultRequest(HttpMethod.DELETE, href, null, this.headers.clone(), null, 0L);
        return this.executeRequest((IRequest)request, responseType);
    }

    public <T> T deleteWithObject(Object obj, String href, Class<T> responseType) throws IdxRestException {
        if (this.requestExecutor == null) {
            throw new IllegalStateException("Object not initialised");
        }
        byte[] bodyBytes = null;
        try {
            bodyBytes = this.mapper.writeValueAsBytes(obj);
        }
        catch (Exception ex) {
            throw new IdxRestException("Failed to make the REST call: before calling, failed to serialize the passed object to JSON", ex);
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(bodyBytes);
        int length = bis.available();
        DefaultRequest request = new DefaultRequest(HttpMethod.DELETE, href, null, this.headers.clone(), (InputStream)bis, (long)length);
        return this.executeRequest((IRequest)request, responseType);
    }

    public <T> T executeRequest(IRequest request, Class<T> responseType) throws IdxRestException {
        if (request instanceof DefaultRequest) {
            HttpHeaders headers = ((DefaultRequest)request).getHeaders();
            headers.add("ClientType", Version.sdkVersionValue);
            if (this.getCookie() != null) {
                headers.add("Cookie", this.getCookie());
            }
        }
        IResponse response = null;
        try {
            response = this.requestExecutor.executeRequest(request);
        }
        catch (RestException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RestException("Failed to make the REST call", (Throwable)ex);
        }
        if (response == null) {
            throw new RestException("Failed to make the REST call, no response received");
        }
        if (response.getHttpStatus() < 200 || response.getHttpStatus() >= 300) {
            IdxRestException idxRestException = null;
            try {
                if (response.getBody().available() > 0) {
                    idxRestException = (IdxRestException)this.mapper.readValue(response.getBody(), IdxRestException.class);
                } else {
                    idxRestException = new IdxRestException();
                    idxRestException.setHttpStatus(response.getHttpStatus());
                }
            }
            catch (Exception ex) {
                throw new RestException("Failed to make the REST call; Response was " + response.getBody(), (Throwable)ex, response.getHttpStatus());
            }
            throw idxRestException;
        }
        try {
            if (responseType != null && response.getHeaders().getContentType() != null && response.getHeaders().getContentType().toString().startsWith("application/json")) {
                return (T)this.mapper.readValue(response.getBody(), responseType);
            }
            return null;
        }
        catch (Exception ex) {
            throw new RestException("REST call executed on the server but failed to map the response to required type", (Throwable)ex, response.getHttpStatus());
        }
    }

    public <T> T list(QueryHolder queryHolder, String href, Class<T> responseType) throws IdxRestException {
        QueryString queryString = null;
        queryString = new QueryString();
        if (queryHolder != null) {
            Map<String, String> sortValues;
            Map<String, String> searchValues;
            if (queryHolder.getExpandSpec() != null) {
                try {
                    queryString.put((Object)"expand", (Object)this.getObjectMapper().writeValueAsString((Object)queryHolder.getExpandSpec()));
                }
                catch (JsonProcessingException e) {
                    throw new IdxRestException("Failed to convert to JSON", (Exception)((Object)e));
                }
            }
            if (queryHolder.getPageSpec() != null) {
                queryString.put((Object)"page", (Object)Integer.toString(queryHolder.getPageSpec().getPage()));
                queryString.put((Object)"limit", (Object)Integer.toString(queryHolder.getPageSpec().getLimit()));
            }
            if (queryHolder.getSensitiveDataSpec() != null) {
                queryString.put((Object)"sensitiveData", (Object)String.valueOf(queryHolder.getSensitiveDataSpec().getSensitiveData()));
            }
            if (queryHolder.isIncludeAuthorizationInfo()) {
                queryString.put((Object)"includeAuthorizationInfo", (Object)"true");
            }
            if (queryHolder.getSearchSpec() != null && (searchValues = queryHolder.getSearchSpec().buildSearchValues()) != null) {
                for (String name : searchValues.keySet()) {
                    queryString.put((Object)name, (Object)searchValues.get(name));
                }
            }
            if (queryHolder.getSortSpec() != null && (sortValues = queryHolder.getSortSpec().buildSearchValues()) != null) {
                for (String name : sortValues.keySet()) {
                    queryString.put((Object)name, (Object)sortValues.get(name));
                }
            }
        }
        T result = this.get(queryString, href, responseType);
        return result;
    }

    public IApiKey getApiKey() {
        return this.apiKey;
    }

    protected void setApiKey(IApiKey apiKey) {
        this.apiKey = apiKey;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    protected void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public String getCookie() {
        return this.cookie;
    }

    public void setCookie(String cookie) {
        this.cookie = cookie;
    }

    public SSLConnectionSocketFactory getSSLConnectionSocketFactory() {
        return this.sslCSF;
    }

    protected void setSSLConnectionSocketFactory(SSLConnectionSocketFactory sslCSF) {
        this.sslCSF = sslCSF;
    }

    public static class RestClientBuilder {
        private IRequestExecutor requestExecutor = null;
        private ObjectMapper mapper = null;
        private IApiKey apiKey;
        private IApiKey responseApiKey;
        private Proxy proxy = null;
        private String cookie = null;
        private SSLConnectionSocketFactory sslCSF;
        private boolean ignoreCookies = true;
        private boolean useBasicIDX = false;
        private HttpHeaders headers;

        public RestClientBuilder setRequestExecutor(IRequestExecutor requestExecutor) {
            this.requestExecutor = requestExecutor;
            if (requestExecutor instanceof HttpClientRequestExecutor) {
                this.apiKey = ((HttpClientRequestExecutor)requestExecutor).getApiKey();
            }
            return this;
        }

        public RestClientBuilder setIgnoreCookies(boolean ignoreCookies) {
            this.ignoreCookies = ignoreCookies;
            return this;
        }

        public RestClientBuilder setApiKey(IApiKey apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public RestClientBuilder setBasicIDX(boolean useBasicIDX) {
            this.useBasicIDX = useBasicIDX;
            return this;
        }

        public RestClientBuilder setResponseApiKey(IApiKey responseApiKey) {
            this.responseApiKey = responseApiKey;
            return this;
        }

        public RestClientBuilder setProxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public RestClientBuilder setHeaders(HttpHeaders headers) {
            this.headers = headers;
            return this;
        }

        public RestClientBuilder setCookie(String cookie) {
            this.cookie = cookie;
            return this;
        }

        public RestClientBuilder setSSLConnectionSocketFactory(SSLConnectionSocketFactory sslCSF) {
            this.sslCSF = sslCSF;
            return this;
        }

        public RestClientBuilder setObjectMapper(ObjectMapper mapper) {
            this.mapper = mapper;
            return this;
        }

        public RestClient build() {
            RestClient restClient = new RestClient();
            if (this.mapper != null) {
                restClient.setObjectMapper(this.mapper);
            }
            if (this.headers != null) {
                restClient.setHeaders(this.headers);
            }
            if (this.apiKey != null) {
                restClient.setApiKey(this.apiKey);
            }
            restClient.setProxy(this.proxy);
            if (this.requestExecutor == null) {
                if (this.useBasicIDX) {
                    restClient.init(this.apiKey, this.useBasicIDX, this.sslCSF, this.ignoreCookies);
                } else {
                    restClient.init(this.apiKey, this.responseApiKey, this.sslCSF, this.ignoreCookies);
                }
            } else {
                restClient.setRequestExecutor(this.requestExecutor);
            }
            restClient.setCookie(this.cookie);
            return restClient;
        }
    }
}

