/*
 * Decompiled with CFR 0.152.
 */
package com.identityx.clientSDK.piiSupport;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.identityx.clientSDK.piiSupport.DisplayPNGCharacteristics;
import com.identityx.clientSDK.piiSupport.transactionContentProviders.ITransactionContentProvider;
import java.io.StringWriter;
import java.io.Writer;

public class FidoRequestUtil {
    public String replaceTransactionContent(String fidoAuthRequestJson, ITransactionContentProvider[] transactionContentProviders) {
        StringWriter mjson = new StringWriter();
        JsonWriter jsonWriter = new JsonWriter((Writer)mjson);
        Gson gson = new Gson();
        Object data = gson.fromJson(fidoAuthRequestJson, Object.class);
        JsonArray jsonArray = (JsonArray)gson.toJsonTree(data);
        for (JsonElement ielement : jsonArray) {
            JsonObject iobject = ielement.getAsJsonObject();
            JsonElement transactionElement = iobject.get("transaction");
            JsonArray iarray = transactionElement.getAsJsonArray();
            for (JsonElement jelement : iarray) {
                JsonObject transObj = jelement.getAsJsonObject();
                JsonElement contentTypeElem = transObj.get("contentType");
                for (ITransactionContentProvider transactionContentProvider : transactionContentProviders) {
                    if (!transactionContentProvider.isContentTypeSupported(contentTypeElem.getAsString())) continue;
                    JsonElement tcDisplayElem = transObj.get("tcDisplayPNGCharacteristics");
                    if (tcDisplayElem != null) {
                        JsonObject dcObj = tcDisplayElem.getAsJsonObject();
                        DisplayPNGCharacteristics display = (DisplayPNGCharacteristics)gson.fromJson((JsonElement)dcObj, DisplayPNGCharacteristics.class);
                        String base64Image = transactionContentProvider.getContent(display);
                        transObj.addProperty("content", base64Image);
                        continue;
                    }
                    transObj.addProperty("content", transactionContentProvider.getContent());
                }
            }
        }
        gson.toJson((JsonElement)jsonArray, jsonWriter);
        return mjson.toString();
    }

    public String replaceUsername(String fidoRegRequestJson, String newUsername) {
        StringWriter mjson = new StringWriter();
        JsonWriter jsonWriter = new JsonWriter((Writer)mjson);
        Gson gson = new Gson();
        Object data = gson.fromJson(fidoRegRequestJson, Object.class);
        JsonArray jsonArray = (JsonArray)gson.toJsonTree(data);
        for (JsonElement ielement : jsonArray) {
            JsonObject iobject = ielement.getAsJsonObject();
            iobject.addProperty("username", newUsername);
        }
        gson.toJson((JsonElement)jsonArray, jsonWriter);
        return mjson.toString();
    }
}

