/*
 * Decompiled with CFR 0.152.
 */
package com.identityx.clientSDK.piiSupport;

import com.identityx.clientSDK.piiSupport.DisplayPNGCharacteristics;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PNGUtility {
    private static final Log logger = LogFactory.getLog(PNGUtility.class);
    private List<Integer> fontSizes = Arrays.asList(60, 48, 36, 28, 26, 24, 22, 20, 18, 16, 14, 12, 11, 10, 9, 8);

    public BufferedImage createPNGFromBase64Data(String content) throws IOException {
        BufferedImage bufferedImage = null;
        byte[] imageContent = Base64.decodeBase64((String)content);
        try {
            bufferedImage = ImageIO.read(new ByteArrayInputStream(imageContent));
        }
        catch (IOException e) {
            logger.error((Object)"The PNG Data supplied for the transaction was not valid");
            throw e;
        }
        return bufferedImage;
    }

    public BufferedImage resizePNGFromBase64Data(DisplayPNGCharacteristics descriptor, String content) throws IOException {
        BufferedImage bufferedImage = null;
        byte[] imageContent = Base64.decodeBase64((String)content);
        BufferedImage scaledImage = null;
        if (descriptor != null) {
            try {
                bufferedImage = ImageIO.read(new ByteArrayInputStream(imageContent));
                scaledImage = this.getScaledInstance(bufferedImage, (int)descriptor.getWidth(), (int)descriptor.getHeight(), RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR, false);
            }
            catch (IOException e) {
                logger.error((Object)"The PNG Data supplied for the transaction was not valid");
                throw e;
            }
            return scaledImage;
        }
        logger.error((Object)"Null DisplayPNGCharacteristicsDescriptor supplied so just returning the original image");
        return bufferedImage;
    }

    public String createBase64DatafromPNG(BufferedImage image) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, "png", baos);
        }
        catch (IOException e) {
            logger.error((Object)"Failed to write the scaled PNG image");
            throw e;
        }
        return Base64.encodeBase64URLSafeString((byte[])baos.toByteArray());
    }

    public DisplayPNGCharacteristics getDisplayCharacteristicsOfImage(String content) throws IOException {
        BufferedImage image = this.createPNGFromBase64Data(content);
        DisplayPNGCharacteristics pngDescriptor = new DisplayPNGCharacteristics();
        int bitDepth = image.getColorModel().getPixelSize();
        pngDescriptor.setBitDepth(bitDepth);
        pngDescriptor.setWidth(image.getWidth());
        pngDescriptor.setHeight(image.getHeight());
        return pngDescriptor;
    }

    public BufferedImage getScaledInstance(BufferedImage img, int targetWidth, int targetHeight, Object hint, boolean higherQuality) {
        int type = img.getTransparency() == 1 ? 1 : 2;
        BufferedImage ret = img;
        int h = img.getHeight();
        int w = img.getWidth();
        if (higherQuality) {
            double scaleFactor = this.determineImageScale(w, h, targetWidth, targetHeight);
            w = (int)((double)w * scaleFactor);
            h = (int)((double)h * scaleFactor);
        } else {
            h = targetHeight;
        }
        w = targetWidth;
        do {
            if (higherQuality && w > targetWidth && (w /= 2) < targetWidth) {
                w = targetWidth;
            }
            if (higherQuality && h > targetHeight && (h /= 2) < targetHeight) {
                h = targetHeight;
            }
            BufferedImage tmp = new BufferedImage(w, h, type);
            Graphics2D g2 = tmp.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, hint);
            g2.drawImage(ret, 0, 0, w, h, null);
            g2.dispose();
            ret = tmp;
        } while (w > targetWidth || h > targetHeight);
        return ret;
    }

    public double determineImageScale(int sourceWidth, int sourceHeight, int targetWidth, int targetHeight) {
        double scalex = (double)targetWidth / (double)sourceWidth;
        double scaley = (double)targetHeight / (double)sourceHeight;
        return Math.min(scalex, scaley);
    }

    public String createBase64ImageFromText(String text, int width, int height) throws IOException {
        int leftPadding = 2;
        int rightPadding = 10;
        TextDetails details = this.getFontSize(text, width - leftPadding - rightPadding, height);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Creating PNG image from text, using font size: " + String.valueOf(details.getFontSize()) + " width: " + String.valueOf(width) + " and text: " + text));
        }
        BufferedImage img = new BufferedImage(width, height, 2);
        Graphics2D g2d = img.createGraphics();
        Font font = new Font("Arial", 0, details.getFontSize());
        g2d.setFont(font);
        g2d.setBackground(Color.WHITE);
        g2d.clearRect(0, 0, width, height);
        g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g2d.setFont(font);
        FontMetrics fm = g2d.getFontMetrics();
        g2d.setColor(Color.BLACK);
        int counter = 1;
        for (String line : details.getLines()) {
            g2d.drawString(line, leftPadding, fm.getAscent() * counter);
            ++counter;
        }
        g2d.dispose();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)img, "png", baos);
        }
        catch (IOException e) {
            logger.error((Object)"Failed to write the text to PNG image");
            throw e;
        }
        return Base64.encodeBase64URLSafeString((byte[])baos.toByteArray());
    }

    public BufferedImage addTransparentBackground(BufferedImage sourceImage, int requiredWidth, int requiredHeight, boolean isCentred) {
        int imageWidth = 0;
        int imageHeight = 0;
        BufferedImage combinedImage = null;
        imageWidth = sourceImage.getWidth();
        imageHeight = sourceImage.getHeight();
        if (imageWidth > requiredWidth || imageHeight > requiredHeight) {
            // empty if block
        }
        combinedImage = new BufferedImage(requiredWidth, requiredHeight, 2);
        Graphics2D g2d = combinedImage.createGraphics();
        if (isCentred) {
            g2d.drawImage((Image)sourceImage, (requiredWidth - imageWidth) / 2, (requiredHeight - imageHeight) / 2, null);
        } else {
            g2d.drawImage((Image)sourceImage, 0, 0, null);
        }
        return combinedImage == null ? sourceImage : combinedImage;
    }

    private TextDetails getFontSize(String text, int width, int height) {
        BufferedImage img = new BufferedImage(1, 1, 2);
        Graphics2D g2d = img.createGraphics();
        Font font = null;
        int testWidth = 0;
        int testHeight = 0;
        int numPossibleLines = 1;
        TextDetails details = null;
        for (int size : this.fontSizes) {
            font = new Font("Arial", 0, size);
            g2d.setFont(font);
            FontMetrics fm = g2d.getFontMetrics();
            testWidth = fm.stringWidth(text);
            if (testWidth <= width) {
                g2d.dispose();
                return new TextDetails(size, text, false);
            }
            testHeight = fm.getHeight();
            numPossibleLines = height / testHeight;
            if (testWidth > width * numPossibleLines) continue;
            details = new TextDetails(size);
            if ((details = this.splitToMultiLine(text, width, numPossibleLines, fm, details)).isOverrun()) continue;
            g2d.dispose();
            return details;
        }
        g2d.dispose();
        return details;
    }

    private TextDetails splitToMultiLine(String text, int width, int numPossibleLines, FontMetrics fm, TextDetails details) {
        int index;
        if (fm.stringWidth(text) < width) {
            details.addLine(text);
            details.setOverrun(false);
            return details;
        }
        if (numPossibleLines == 1) {
            details.addLine(text);
            details.setOverrun(true);
            return details;
        }
        String thisLine = "";
        String testLine = "";
        String remainingText = null;
        int prevIndex = 0;
        while (prevIndex < text.length() && (index = text.indexOf(" ", prevIndex)) != -1 && fm.stringWidth(testLine = text.substring(0, index)) < width) {
            thisLine = testLine;
            prevIndex = index + 1;
        }
        details.addLine(thisLine);
        remainingText = text.substring(thisLine.length() + 1);
        return this.splitToMultiLine(remainingText, width, numPossibleLines - 1, fm, details);
    }

    class TextDetails {
        private List<String> lines = new ArrayList<String>();
        private int fontSize;
        private boolean overrun;

        public TextDetails(int fontSize, String firstLine, boolean overrun) {
            this.lines.add(firstLine);
            this.fontSize = fontSize;
            this.overrun = overrun;
        }

        public TextDetails(int fontSize, boolean overrun) {
            this.fontSize = fontSize;
            this.overrun = overrun;
        }

        public TextDetails(int fontSize) {
            this.fontSize = fontSize;
        }

        public List<String> getLines() {
            return this.lines;
        }

        public void addLine(String line) {
            this.lines.add(line);
        }

        public int getFontSize() {
            return this.fontSize;
        }

        public void setFontSize(int fontSize) {
            this.fontSize = fontSize;
        }

        public boolean isOverrun() {
            return this.overrun;
        }

        public void setOverrun(boolean overrun) {
            this.overrun = overrun;
        }
    }
}

