/*
 * Decompiled with CFR 0.152.
 */
package com.identityx.clientSDK.piiSupport.transactionContentProviders;

import com.identityx.clientSDK.piiSupport.DisplayPNGCharacteristics;
import com.identityx.clientSDK.piiSupport.PNGUtility;
import com.identityx.clientSDK.piiSupport.transactionContentProviders.ITransactionContentProvider;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.commons.codec.binary.Base64;

public class ImageTransactionContentProvider
implements ITransactionContentProvider {
    private byte[] imageToDisplay = null;
    private String textToDisplay = null;
    private Map<DisplayPNGCharacteristics, String> createdContent = new HashMap<DisplayPNGCharacteristics, String>();
    private int defaultWidth = 320;
    private int defaultHeight = 320;

    public int getDefaultWidth() {
        return this.defaultWidth;
    }

    public void setDefaultWidth(int defaultWidth) {
        this.defaultWidth = defaultWidth;
    }

    public int getDefaultHeight() {
        return this.defaultHeight;
    }

    public void setDefaultHeight(int defaultHeight) {
        this.defaultHeight = defaultHeight;
    }

    public byte[] getImageContent() {
        return this.imageToDisplay;
    }

    public String getTextContent() {
        return this.textToDisplay;
    }

    public ImageTransactionContentProvider(byte[] imageToDisplay) {
        this.imageToDisplay = imageToDisplay;
    }

    public ImageTransactionContentProvider(String textToDisplay) {
        this.textToDisplay = textToDisplay;
    }

    @Override
    public String getContent() {
        String content = null;
        try {
            PNGUtility pngUtility = new PNGUtility();
            if (this.imageToDisplay != null) {
                BufferedImage bufferedImage = null;
                bufferedImage = ImageIO.read(new ByteArrayInputStream(this.imageToDisplay));
                content = pngUtility.createBase64DatafromPNG(bufferedImage);
            } else {
                content = pngUtility.createBase64ImageFromText(new String(Base64.decodeBase64((String)this.textToDisplay)), this.defaultWidth, this.defaultHeight);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return content;
    }

    @Override
    public String getContent(DisplayPNGCharacteristics descriptor) {
        if (descriptor == null) {
            return this.getContent();
        }
        if (this.createdContent.containsKey(descriptor)) {
            return this.createdContent.get(descriptor);
        }
        String content = null;
        try {
            PNGUtility pngUtility = new PNGUtility();
            if (this.imageToDisplay != null) {
                BufferedImage scaledImage = null;
                BufferedImage bufferedImage = null;
                bufferedImage = ImageIO.read(new ByteArrayInputStream(this.imageToDisplay));
                scaledImage = pngUtility.getScaledInstance(bufferedImage, (int)descriptor.getWidth(), (int)descriptor.getHeight(), RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR, true);
                scaledImage = pngUtility.addTransparentBackground(scaledImage, (int)descriptor.getWidth(), (int)descriptor.getHeight(), true);
                content = pngUtility.createBase64DatafromPNG(scaledImage);
            } else {
                content = pngUtility.createBase64ImageFromText(new String(Base64.decodeBase64((String)this.textToDisplay)), (int)descriptor.getWidth(), (int)descriptor.getHeight());
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        this.createdContent.put(descriptor, content);
        return content;
    }

    public Map<DisplayPNGCharacteristics, String> getCreatedContent() {
        return this.createdContent;
    }

    @Override
    public boolean isContentTypeSupported(String contentType) {
        return contentType.toLowerCase().equals("image/png");
    }
}

