/*
 * Decompiled with CFR 0.152.
 */
package com.identityx.clientSDK.queryHolders;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.identityx.clientSDK.queryHolders.QueryHolder;
import com.identityx.clientSDK.queryHolders.SearchSpec;
import com.identityx.clientSDK.queryHolders.SensitiveDataSpec;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class FidoAAIDStatisticQueryHolder
extends QueryHolder {
    private FidoAAIDStatisticSearchSpec searchSpec = new FidoAAIDStatisticSearchSpec();

    public FidoAAIDStatisticQueryHolder() {
        this.setSensitiveDataSpec(new SensitiveDataSpec());
    }

    @Override
    public FidoAAIDStatisticSearchSpec getSearchSpec() {
        return this.searchSpec;
    }

    public class FidoAAIDStatisticSearchSpec
    extends SearchSpec {
        private String start;
        private String end;

        @JsonIgnore
        public Date getStartDate() throws ParseException {
            return this.convertString(this.start);
        }

        @JsonIgnore
        public void setStartDate(Date start) {
            this.start = this.convertDate(start);
        }

        @JsonIgnore
        public Date getEndDate() throws ParseException {
            return this.convertString(this.end);
        }

        @JsonIgnore
        public void setEndDate(Date end) {
            this.end = this.convertDate(end);
        }

        public String getStart() {
            return this.start;
        }

        public void setStart(String start) {
            this.start = start;
        }

        public String getEnd() {
            return this.end;
        }

        public void setEnd(String end) {
            this.end = end;
        }

        protected String convertDate(Date date) {
            TimeZone tz = TimeZone.getTimeZone("UTC");
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            df.setTimeZone(tz);
            return df.format(date);
        }

        protected Date convertString(String date) throws ParseException {
            TimeZone tz = TimeZone.getTimeZone("UTC");
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            df.setTimeZone(tz);
            return df.parse(date);
        }
    }
}

