/*
 * Decompiled with CFR 0.152.
 */
package com.identityx.clientSDK.repositories;

import com.daon.identityx.rest.model.def.ResourcePaths;
import com.daon.identityx.rest.model.pojo.AuthenticationRequest;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.identityx.auth.impl.QueryString;
import com.identityx.clientSDK.collections.AuthenticationRequestCollection;
import com.identityx.clientSDK.exceptions.IdxRestException;
import com.identityx.clientSDK.expandSpecs.AuthenticationRequestExpandSpecForGet;
import com.identityx.clientSDK.queryHolders.AuthenticationRequestQueryHolder;
import com.identityx.clientSDK.queryHolders.SensitiveDataSpec;
import com.identityx.clientSDK.repositories.BaseRepository;

public class AuthenticationRequestRepository
extends BaseRepository<AuthenticationRequest, AuthenticationRequestCollection, AuthenticationRequestQueryHolder> {
    public AuthenticationRequestRepository() {
        super(AuthenticationRequest.class, AuthenticationRequestCollection.class);
        this.setResourcePath(ResourcePaths.defaultAuthenticationRequestPath);
    }

    public AuthenticationRequest get(String href, AuthenticationRequestExpandSpecForGet expandSpec, SensitiveDataSpec sensitiveDataSpec) throws IdxRestException {
        QueryString queryString = new QueryString();
        if (expandSpec != null) {
            try {
                queryString.put((Object)"expand", (Object)new ObjectMapper().writeValueAsString((Object)expandSpec));
            }
            catch (JsonProcessingException e) {
                throw new IdxRestException("Failed to convert to JSON", (Exception)((Object)e));
            }
        }
        if (sensitiveDataSpec != null) {
            queryString.put((Object)"sensitiveData", (Object)String.valueOf(sensitiveDataSpec.getSensitiveData()));
        }
        return (AuthenticationRequest)super.get(href, queryString);
    }

    public AuthenticationRequest decline(AuthenticationRequest entity) throws IdxRestException {
        AuthenticationRequest result = this.getRestClient().post(null, entity.getHref() + "/declined", AuthenticationRequest.class);
        return result;
    }

    public AuthenticationRequest fraud(AuthenticationRequest entity) throws IdxRestException {
        AuthenticationRequest result = this.getRestClient().post(null, entity.getHref() + "/fraud", AuthenticationRequest.class);
        return result;
    }

    public AuthenticationRequest addFailedClientAttempt(AuthenticationRequest entity) throws IdxRestException {
        AuthenticationRequest result = this.getRestClient().post(entity, entity.getHref() + "/appendFailedAttempt", AuthenticationRequest.class);
        return result;
    }
}

