/*
 * Decompiled with CFR 0.152.
 */
package com.identityx.clientSDK.repositories;

import com.daon.identityx.rest.model.def.ResourcePaths;
import com.daon.identityx.rest.model.pojo.Authenticator;
import com.daon.identityx.rest.model.support.AuthenticatorArchiveCriteria;
import com.daon.identityx.rest.model.support.AuthenticatorBlockCriteria;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.identityx.auth.impl.QueryString;
import com.identityx.clientSDK.collections.AuthenticatorCollection;
import com.identityx.clientSDK.exceptions.IdxRestException;
import com.identityx.clientSDK.expandSpecs.AuthenticatorExpandSpecForGet;
import com.identityx.clientSDK.queryHolders.AuthenticatorQueryHolder;
import com.identityx.clientSDK.queryHolders.SensitiveDataSpec;
import com.identityx.clientSDK.repositories.BaseRepository;

public class AuthenticatorRepository
extends BaseRepository<Authenticator, AuthenticatorCollection, AuthenticatorQueryHolder> {
    public AuthenticatorRepository() {
        super(Authenticator.class, AuthenticatorCollection.class);
        this.setResourcePath(ResourcePaths.defaultAuthenticatorPath);
    }

    public Authenticator get(String href, AuthenticatorExpandSpecForGet expandSpec, SensitiveDataSpec sensitiveDataSpec) throws IdxRestException {
        QueryString queryString = new QueryString();
        if (expandSpec != null) {
            try {
                queryString.put((Object)"expand", (Object)new ObjectMapper().writeValueAsString((Object)expandSpec));
            }
            catch (JsonProcessingException e) {
                throw new IdxRestException("Failed to convert to JSON", (Exception)((Object)e));
            }
        }
        if (sensitiveDataSpec != null) {
            queryString.put((Object)"sensitiveData", (Object)String.valueOf(sensitiveDataSpec.getSensitiveData()));
        }
        return (Authenticator)super.get(href, queryString);
    }

    public Authenticator forceUnblock(Authenticator entity) throws IdxRestException {
        return this.getRestClient().post(null, entity.getHref() + "/unblocked", Authenticator.class);
    }

    public Authenticator archive(Authenticator entity, AuthenticatorArchiveCriteria archiveCriteria) throws IdxRestException {
        Authenticator result = this.getRestClient().post(archiveCriteria, entity.getHref() + "/archived", Authenticator.class);
        return result;
    }

    public Authenticator block(Authenticator entity, AuthenticatorBlockCriteria blockCriteria) throws IdxRestException {
        Authenticator result = this.getRestClient().post(blockCriteria, entity.getHref() + "/blocked", Authenticator.class);
        return result;
    }
}

