/*
 * Decompiled with CFR 0.152.
 */
package com.identityx.clientSDK.repositories;

import com.daon.identityx.rest.model.def.IRestResource;
import com.daon.identityx.rest.model.pojo.RestCollection;
import com.identityx.auth.def.IApiKey;
import com.identityx.auth.impl.QueryString;
import com.identityx.clientSDK.base.RestClient;
import com.identityx.clientSDK.exceptions.IdxRestException;
import com.identityx.clientSDK.queryHolders.QueryHolder;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;

public class BaseRepository<T extends IRestResource, U extends RestCollection<T>, V extends QueryHolder> {
    private String baseUrl;
    private Class<T> type;
    private Class<U> collectionClass;
    private String resourcePath;
    private RestClient restClient = new RestClient();

    public BaseRepository(Class<T> type, Class<U> collectionClass) {
        this.type = type;
        this.collectionClass = collectionClass;
    }

    public void init(RestClient restClient, String baseUrl) {
        this.restClient = restClient;
        this.baseUrl = baseUrl;
    }

    public void init(RestClient restClient, String baseUrl, String resourcePath) {
        this.restClient = restClient;
        this.baseUrl = baseUrl;
        this.resourcePath = resourcePath;
    }

    public void init(IApiKey apiKey, String baseUrl, SSLConnectionSocketFactory sslCSF, boolean ignoreCookies) {
        this.getRestClient().init(apiKey, sslCSF, ignoreCookies);
        this.baseUrl = baseUrl;
    }

    public void init(IApiKey apiKey, String baseUrl, String cookie, String resourcePath, SSLConnectionSocketFactory sslCSF) {
        this.resourcePath = resourcePath;
        this.init(apiKey, baseUrl, sslCSF, true);
        this.getRestClient().setCookie(cookie);
    }

    public void init(IApiKey apiKey, String baseUrl, String cookie, SSLConnectionSocketFactory sslCSF) {
        this.init(apiKey, baseUrl, sslCSF, true);
        this.getRestClient().setCookie(cookie);
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public T create(T entity) throws IdxRestException {
        IRestResource result = (IRestResource)this.getRestClient().post(entity, this.getBaseUrl() + "/" + this.getResourcePath(), this.type);
        return (T)result;
    }

    public T update(T entity) throws IdxRestException {
        IRestResource result = (IRestResource)this.getRestClient().post(entity, entity.getHref(), this.type);
        return (T)result;
    }

    public T get(String href) throws IdxRestException {
        IRestResource result = (IRestResource)this.getRestClient().get(new QueryString(), href, this.type);
        return (T)result;
    }

    public T getById(String id) throws IdxRestException {
        String href = this.getBaseUrl() + "/" + this.getResourcePath() + "/" + id;
        IRestResource result = (IRestResource)this.getRestClient().get(new QueryString(), href, this.type);
        return (T)result;
    }

    public T get(String href, QueryString queryString) throws IdxRestException {
        IRestResource result = (IRestResource)this.getRestClient().get(queryString, href, this.type);
        return (T)result;
    }

    public U list(String href, V queryHolder) throws IdxRestException {
        RestCollection result = (RestCollection)this.getRestClient().list((QueryHolder)queryHolder, href, this.collectionClass);
        return (U)result;
    }

    public U list(V queryHolder) throws IdxRestException {
        RestCollection result = (RestCollection)this.getRestClient().list((QueryHolder)queryHolder, this.getBaseUrl() + "/" + this.getResourcePath(), this.collectionClass);
        return (U)result;
    }

    public T block(T entity) throws IdxRestException {
        IRestResource result = (IRestResource)this.getRestClient().post(null, entity.getHref() + "/blocked", this.type);
        return (T)result;
    }

    public T unblock(T entity) throws IdxRestException {
        IRestResource result = (IRestResource)this.getRestClient().delete(entity.getHref() + "/blocked", this.type);
        return (T)result;
    }

    public T archive(T entity) throws IdxRestException {
        IRestResource result = (IRestResource)this.getRestClient().post(null, entity.getHref() + "/archived", this.type);
        return (T)result;
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    public RestClient getRestClient() {
        return this.restClient;
    }

    public void setRestClient(RestClient restClient) {
        this.restClient = restClient;
    }
}

