/*
 * Decompiled with CFR 0.152.
 */
package com.identityx.clientSDK.repositories;

import com.daon.identityx.rest.model.def.DataTypeEnum;
import com.daon.identityx.rest.model.def.ResourcePaths;
import com.daon.identityx.rest.model.pojo.User;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.identityx.auth.impl.QueryString;
import com.identityx.clientSDK.collections.UserCollection;
import com.identityx.clientSDK.exceptions.IdxRestException;
import com.identityx.clientSDK.expandSpecs.UserExpandSpecForGet;
import com.identityx.clientSDK.queryHolders.SensitiveDataSpec;
import com.identityx.clientSDK.queryHolders.UserQueryHolder;
import com.identityx.clientSDK.repositories.BaseRepository;

public class UserRepository
extends BaseRepository<User, UserCollection, UserQueryHolder> {
    public UserRepository() {
        super(User.class, UserCollection.class);
        this.setResourcePath(ResourcePaths.defaultUserPath);
    }

    public void delete(User entity) throws IdxRestException {
        this.getRestClient().delete(entity.getHref(), User.class);
    }

    public void deleteData(User entity, DataTypeEnum dataType) throws IdxRestException {
        this.getRestClient().delete(entity.getHref() + "/" + dataType, User.class);
    }

    public User unblockData(User entity, DataTypeEnum dataType) throws IdxRestException {
        return this.getRestClient().delete(entity.getHref() + "/" + dataType + "/blocked", User.class);
    }

    public User get(String href, UserExpandSpecForGet expandSpec, SensitiveDataSpec sensitiveDataSpec) throws IdxRestException {
        QueryString queryString = new QueryString();
        if (expandSpec != null) {
            try {
                queryString.put((Object)"expand", (Object)new ObjectMapper().writeValueAsString((Object)expandSpec));
            }
            catch (JsonProcessingException e) {
                throw new IdxRestException("Failed to convert to JSON", (Exception)((Object)e));
            }
        }
        if (sensitiveDataSpec != null) {
            queryString.put((Object)"sensitiveData", (Object)String.valueOf(sensitiveDataSpec.getSensitiveData()));
        }
        return (User)super.get(href, queryString);
    }
}

