/*
 * Decompiled with CFR 0.152.
 */
package com.daon.identityx.rest.model.pojo;

import com.daon.identityx.rest.model.pojo.PermissionSelector;

public class Permission {
    public static final int CREATE = 1;
    public static final int UPDATE = 2;
    public static final int GET = 4;
    public static final int DELETE = 8;
    public static final int BLOCK = 16;
    public static final int UNBLOCK = 32;
    public static final int ALL_OPERATIONS = 63;
    public static final String operationSeparator = ",";
    public static final String entitySeparator = ",";
    public static final String entityNameAll = "*";
    public static final String operationsAll = "*";
    public static final int Application = 1;
    public static final int Audit = 2;
    public static final int AuthenticationRequest = 4;
    public static final int Authenticator = 8;
    public static final int SystemAuthenticatorType = 16;
    public static final int Policy = 32;
    public static final int RegistrationChallenge = 64;
    public static final int Registration = 128;
    public static final int Role = 256;
    public static final int Sponsorship = 512;
    public static final int AuthenticatorType = 1024;
    public static final int Tenant = 2048;
    public static final int Token = 4096;
    public static final int User = 8192;
    public static final int Configuration = 16384;
    public static final int AuthenticationRequestSensitiveData = 32768;
    public static final int AuthenticatorSensitiveData = 65536;
    public static final int UserSensitiveData = 131072;
    public static final int Statistics = 262144;
    public static final int SponsorshipSensitiveData = 524288;
    public static final int All_Entities = 1048575;
    public static final String permissionPartsSeparator = ":";
    private String entity = "*";
    private String operation = "*";
    private PermissionSelector permissionSelector = new PermissionSelector();

    public String getEntity() {
        return this.entity;
    }

    public void setEntity(String entity) {
        this.entity = entity;
    }

    public String getOperation() {
        return this.operation.replaceAll("\\s", "");
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public static String entitiesFromFlags(int entity) {
        String value = "";
        if ((entity & 0xFFFFF) == 1048575) {
            return "*";
        }
        if ((entity & 1) == 1) {
            value = (Object)((Object)EntityNameEnum.Application) + ",";
        }
        if ((entity & 2) == 2) {
            value = (Object)((Object)EntityNameEnum.Audit) + ",";
        }
        if ((entity & 4) == 4) {
            value = (Object)((Object)EntityNameEnum.AuthenticationRequest) + ",";
        }
        if ((entity & 8) == 8) {
            value = (Object)((Object)EntityNameEnum.Authenticator) + ",";
        }
        if ((entity & 0x10) == 16) {
            value = (Object)((Object)EntityNameEnum.SystemAuthenticatorType) + ",";
        }
        if ((entity & 0x20) == 32) {
            value = (Object)((Object)EntityNameEnum.Policy) + ",";
        }
        if ((entity & 0x40) == 64) {
            value = (Object)((Object)EntityNameEnum.RegistrationChallenge) + ",";
        }
        if ((entity & 0x80) == 128) {
            value = (Object)((Object)EntityNameEnum.Registration) + ",";
        }
        if ((entity & 0x100) == 256) {
            value = (Object)((Object)EntityNameEnum.Role) + ",";
        }
        if ((entity & 0x200) == 512) {
            value = (Object)((Object)EntityNameEnum.Sponsorship) + ",";
        }
        if ((entity & 0x400) == 1024) {
            value = (Object)((Object)EntityNameEnum.AuthenticatorType) + ",";
        }
        if ((entity & 0x800) == 2048) {
            value = (Object)((Object)EntityNameEnum.Tenant) + ",";
        }
        if ((entity & 0x1000) == 4096) {
            value = (Object)((Object)EntityNameEnum.Token) + ",";
        }
        if ((entity & 0x2000) == 8192) {
            value = (Object)((Object)EntityNameEnum.User) + ",";
        }
        if ((entity & 0x4000) == 16384) {
            value = (Object)((Object)EntityNameEnum.Configuration) + ",";
        }
        if ((entity & 0x8000) == 32768) {
            value = (Object)((Object)EntityNameEnum.AuthenticationRequestSensitiveData) + ",";
        }
        if ((entity & 0x10000) == 65536) {
            value = (Object)((Object)EntityNameEnum.AuthenticatorSensitiveData) + ",";
        }
        if ((entity & 0x20000) == 131072) {
            value = (Object)((Object)EntityNameEnum.UserSensitiveData) + ",";
        }
        if ((entity & 0x80000) == 524288) {
            value = (Object)((Object)EntityNameEnum.SponsorshipSensitiveData) + ",";
        }
        if (value != null) {
            value = value.substring(0, value.length() - 1);
        }
        return value;
    }

    public static String operationFromFlags(int operation) {
        String value = "";
        if ((operation & 0x3F) == 63) {
            return "*";
        }
        if ((operation & 1) == 1) {
            value = (Object)((Object)OperationTypeEnum.CREATE) + ",";
        }
        if ((operation & 8) == 8) {
            value = value + (Object)((Object)OperationTypeEnum.DELETE) + ",";
        }
        if ((operation & 4) == 4) {
            value = value + (Object)((Object)OperationTypeEnum.GET) + ",";
        }
        if ((operation & 2) == 2) {
            value = value + (Object)((Object)OperationTypeEnum.UPDATE) + ",";
        }
        if ((operation & 0x10) == 16) {
            value = value + (Object)((Object)OperationTypeEnum.BLOCK) + ",";
        }
        if ((operation & 0x20) == 32) {
            value = value + (Object)((Object)OperationTypeEnum.UNBLOCK) + ",";
        }
        if (value != null) {
            value = value.substring(0, value.length() - 1);
        }
        return value;
    }

    public static int flagsFromOperation(String operation) {
        int result = 0;
        if (operation != null) {
            String[] parts;
            if (operation.equals("*")) {
                return 63;
            }
            for (String part : parts = operation.split(",")) {
                if (part.equals((Object)OperationTypeEnum.CREATE)) {
                    result |= 1;
                }
                if (part.equals((Object)OperationTypeEnum.GET)) {
                    result |= 4;
                }
                if (part.equals((Object)OperationTypeEnum.UPDATE)) {
                    result |= 2;
                }
                if (part.equals((Object)OperationTypeEnum.DELETE)) {
                    result |= 8;
                }
                if (part.equals((Object)OperationTypeEnum.BLOCK)) {
                    result |= 0x10;
                }
                if (!part.equals((Object)OperationTypeEnum.UNBLOCK)) continue;
                result |= 0x20;
            }
        }
        return result;
    }

    public PermissionSelector getPermissionSelector() {
        return this.permissionSelector;
    }

    public void setPermissionSelector(PermissionSelector permissionSelector) {
        this.permissionSelector = permissionSelector;
    }

    public String toString() {
        return this.getEntity() + permissionPartsSeparator + this.getOperation() + permissionPartsSeparator + this.getPermissionSelector().toString();
    }

    public static enum OperationTypeEnum {
        CREATE,
        UPDATE,
        DELETE,
        GET,
        BLOCK,
        UNBLOCK,
        ALL;

    }

    public static enum EntityNameEnum {
        Application,
        Audit,
        AuthenticationRequest,
        Authenticator,
        SystemAuthenticatorType,
        Policy,
        RegistrationChallenge,
        Registration,
        Role,
        Sponsorship,
        AuthenticatorType,
        Tenant,
        Token,
        User,
        Configuration,
        AuthenticationRequestSensitiveData,
        AuthenticatorSensitiveData,
        UserSensitiveData,
        Statistics,
        SponsorshipSensitiveData;

    }
}

