/*
 * Decompiled with CFR 0.152.
 */
package com.daon.identityx.rest.model.pojo;

import com.daon.identityx.rest.model.def.ResourcePaths;
import com.daon.identityx.rest.model.pojo.RestResource;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class PermissionSelector {
    private String selectorType = null;
    private RestResource resource = null;
    protected static final Map<String, String> selectorTypes;
    protected static final Map<String, String> selectorEntities;

    public PermissionSelector() {
        this.selectorType = SelectorNamesEnum.GENERIC.toString();
    }

    public PermissionSelector(RestResource resource) {
        if (resource == null || resource.getHref() == null) {
            throw new IllegalArgumentException();
        }
        String[] parts = resource.getHref().split("/");
        if (parts.length < 3) {
            throw new IllegalArgumentException("Bad href");
        }
        String entity = parts[parts.length - 2];
        if (!selectorEntities.keySet().contains(entity)) {
            throw new IllegalArgumentException("Entity type not allowed or bad href");
        }
        this.selectorType = SelectorNamesEnum.WITHIN.toString();
        this.resource = new RestResource(resource.getHref());
    }

    public String getSelectorType() {
        return this.selectorType;
    }

    public void setSelectorType(String selectorType) {
        if (!selectorTypes.containsKey(selectorType)) {
            throw new IllegalArgumentException("A value of " + selectorType + " is invalid");
        }
        this.selectorType = selectorType;
    }

    public RestResource getResource() {
        return this.resource;
    }

    public void setResource(RestResource resource) {
        this.resource = resource;
    }

    public String toString() {
        if (this.selectorType.equals("GENERIC")) {
            return "*";
        }
        if (!selectorTypes.keySet().contains(this.selectorType)) {
            throw new IllegalStateException();
        }
        if (this.selectorType.equals("WITHIN") && (this.resource == null || this.resource.getHref() == null)) {
            throw new IllegalStateException();
        }
        if (this.resource != null && this.resource.getHref() != null) {
            String[] parts = this.resource.getHref().split("/");
            if (parts.length < 3) {
                throw new IllegalStateException();
            }
            String entity = parts[parts.length - 2];
            if (!selectorEntities.keySet().contains(entity)) {
                throw new IllegalStateException();
            }
            String entityId = parts[parts.length - 1];
            return selectorTypes.get(this.selectorType) + selectorEntities.get(entity) + "(" + entityId + ")";
        }
        return selectorTypes.get(this.selectorType);
    }

    static {
        HashMap<String, String> aMap = new HashMap<String, String>();
        aMap.put(SelectorNamesEnum.WITHIN.toString(), "__Within");
        aMap.put(SelectorNamesEnum.WITHIN_CURRENT_USER.toString(), "__WithinCurrentUser");
        aMap.put(SelectorNamesEnum.WITHIN_CURRENT_INSTANCE.toString(), "__WithinCurrentInstance");
        aMap.put(SelectorNamesEnum.GENERIC.toString(), "*");
        selectorTypes = Collections.unmodifiableMap(aMap);
        aMap = new HashMap();
        aMap.put(ResourcePaths.defaultTenantPath, "Tenant");
        aMap.put(ResourcePaths.defaultApplicationPath, "Application");
        selectorEntities = Collections.unmodifiableMap(aMap);
    }

    public static enum SelectorNamesEnum {
        WITHIN,
        GENERIC,
        WITHIN_CURRENT_USER,
        WITHIN_CURRENT_INSTANCE;

    }
}

