/*
 * Copyright 2019 https://www.ifengxue.com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.ifengxue.http.ratelimiter;

import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@NoArgsConstructor
public class RateLimiterConfig {

  /**
   * 等待limit的最大超时时间（毫秒）
   */
  private long timeoutForWaitLimit;

  /**
   * 刷新limit的周期（毫秒）
   */
  private long limitRefreshPeriod;

  /**
   * 每周期允许的请求数量
   */
  private int limitForPeriod;

  public RateLimiterConfig(RateLimiter rateLimiter) {
    this.timeoutForWaitLimit = rateLimiter.timeoutForWaitLimit();
    this.limitRefreshPeriod = rateLimiter.limitRefreshPeriod();
    this.limitForPeriod = rateLimiter.limitForPeriod();
  }
}
