/*
 * Copyright 2019 https://www.ifengxue.com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.ifengxue.http.ratelimiter;

import com.ifengxue.http.ratelimiter.adapter.RateLimiterAdapter;
import com.ifengxue.http.ratelimiter.adapter.ResilienceRateLimiterAdapter;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class RateLimiterManager {

  private static final ConcurrentMap<String, RateLimiterAdapter> CACHE = new ConcurrentHashMap<>();

  public static RateLimiterAdapter getRateLimiterAdapter(RateLimiter rateLimiter) {
    return CACHE.computeIfAbsent(rateLimiter.name(),
        name -> new ResilienceRateLimiterAdapter(name, new RateLimiterConfig(rateLimiter)));
  }
}
