/*
 * Copyright 2019 https://www.ifengxue.com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.ifengxue.http.ratelimiter.adapter;

import com.ifengxue.http.ratelimiter.RateLimiterConfig;

public interface RateLimiterAdapter {

  /**
   * 申请一个permission
   *
   * @param timeoutForWaitLimit 等待limit的最大超时时间（毫秒）
   * @throws RequestLimitedException 无法获取时抛出此异常
   * @throws IllegalStateException 获取permission时，线程状态被设置{@link Thread#interrupt()}
   */
  void requestPermission(long timeoutForWaitLimit) throws RequestLimitedException, IllegalStateException;

  /**
   * 获取 rate limiter config
   */
  RateLimiterConfig getRateLimiterConfig();
}
