/*
 * Decompiled with CFR 0.152.
 */
package com.ifengxue.http.ratelimiter;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.ifengxue.http.HttpClientException;
import com.ifengxue.http.annotation.BodyType;
import com.ifengxue.http.annotation.ResponseType;
import com.ifengxue.http.executor.HttpExecutor;
import com.ifengxue.http.executor.Request;
import com.ifengxue.http.proxy.InterceptorAdaptor;
import com.ifengxue.http.ratelimiter.RateLimiter;
import com.ifengxue.http.ratelimiter.RateLimiterManager;
import com.ifengxue.http.ratelimiter.adapter.RateLimiterAdapter;
import com.ifengxue.http.util.AnnotationUtil;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;

public class RateLimiterInterceptor
extends InterceptorAdaptor {
    private static Cache<Method, RateLimiterHolder> cache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterAccess(Duration.ofMinutes(5L)).build();

    public <T> T beforeRequest(Method method, Request request, BodyType bodyType, ResponseType responseType, HttpExecutor executor) throws HttpClientException {
        try {
            RateLimiterHolder rateLimiterHolder = (RateLimiterHolder)cache.get((Object)method, () -> {
                RateLimiter rateLimiter = (RateLimiter)AnnotationUtil.findAnnotation((Method)method, RateLimiter.class);
                if (rateLimiter == null) {
                    return RateLimiterHolder.EMPTY;
                }
                return new RateLimiterHolder(rateLimiter);
            });
            if (rateLimiterHolder.rateLimiter == null) {
                return null;
            }
            RateLimiterAdapter rateLimiterAdapter = RateLimiterManager.getRateLimiterAdapter(rateLimiterHolder.rateLimiter);
            rateLimiterAdapter.requestPermission(rateLimiterHolder.rateLimiter.timeoutForWaitLimit());
        }
        catch (ExecutionException e) {
            throw new HttpClientException("load cache error", e.getCause());
        }
        return null;
    }

    private static class RateLimiterHolder {
        private static final RateLimiterHolder EMPTY = new RateLimiterHolder(null);
        @Nullable
        private final RateLimiter rateLimiter;

        private RateLimiterHolder(@Nullable RateLimiter rateLimiter) {
            this.rateLimiter = rateLimiter;
        }
    }
}

