/*
 * Decompiled with CFR 0.152.
 */
package com.ifengxue.http.ratelimiter.adapter;

import com.ifengxue.http.ratelimiter.RateLimiterConfig;
import com.ifengxue.http.ratelimiter.adapter.RateLimiterAdapter;
import com.ifengxue.http.ratelimiter.adapter.RequestLimitedException;
import io.github.resilience4j.ratelimiter.RateLimiter;
import java.time.Duration;
import java.time.temporal.ChronoUnit;

public class ResilienceRateLimiterAdapter
implements RateLimiterAdapter {
    private final String name;
    private final RateLimiter rateLimiter;
    private final RateLimiterConfig rateLimiterConfig;

    public ResilienceRateLimiterAdapter(String name, RateLimiterConfig rateLimiterConfig) {
        io.github.resilience4j.ratelimiter.RateLimiterConfig config = io.github.resilience4j.ratelimiter.RateLimiterConfig.custom().timeoutDuration(Duration.of(rateLimiterConfig.getTimeoutForWaitLimit(), ChronoUnit.MILLIS)).limitRefreshPeriod(Duration.of(rateLimiterConfig.getLimitRefreshPeriod(), ChronoUnit.MILLIS)).limitForPeriod(rateLimiterConfig.getLimitForPeriod()).build();
        this.rateLimiter = RateLimiter.of((String)name, (io.github.resilience4j.ratelimiter.RateLimiterConfig)config);
        this.name = name;
        this.rateLimiterConfig = rateLimiterConfig;
    }

    @Override
    public void requestPermission(long timeoutForWaitLimit) throws RequestLimitedException, IllegalStateException {
        boolean permission = this.rateLimiter.getPermission(Duration.of(timeoutForWaitLimit, ChronoUnit.MILLIS));
        if (permission) {
            return;
        }
        if (Thread.currentThread().isInterrupted()) {
            throw new IllegalStateException("Thread was interrupted during permission wait");
        }
        throw new RequestLimitedException("Request limited for limiter: " + this.name);
    }

    @Override
    public RateLimiterConfig getRateLimiterConfig() {
        return this.rateLimiterConfig;
    }
}

