/*
 * Copyright 2019 https://www.ifengxue.com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.ifengxue.http.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * post请求
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.METHOD)
public @interface Post {

  /**
   * 请求方法名称
   *
   * @deprecated {@link HttpMethod#POST}
   */
  @Deprecated
  String METHOD_NAME = "POST";

  /**
   * 请求uri，可以支持<code>{variable}</code>路径变量
   */
  String value() default "";

  /**
   * 请求数据类型
   */
  BodyType bodyType() default BodyType.APPLICATION_JSON;

  /**
   * 响应数据类型
   */
  ResponseType responseType() default ResponseType.APPLICATION_JSON;
}
