/*
 * Copyright 2019 https://www.ifengxue.com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.ifengxue.http.contract;

import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

/**
 * callback handler
 */
public class CallbackHandler {

  private final Callback<?> callback;
  private final Parameter parameter;

  public CallbackHandler(Callback<?> callback, Parameter parameter) {
    this.callback = callback;
    this.parameter = parameter;
  }

  public Callback<?> getCallback() {
    return callback;
  }

  public Type getResponseType() {
    return ((ParameterizedType) parameter.getParameterizedType()).getActualTypeArguments()[0];
  }
}
