/*
 * Copyright 2019 https://www.ifengxue.com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.ifengxue.http.executor;

import com.ifengxue.http.HttpClientException;
import com.ifengxue.http.annotation.BodyType;
import com.ifengxue.http.annotation.ResponseType;
import com.ifengxue.http.contract.HttpResponse;
import com.ifengxue.http.proxy.HttpClientConfig;
import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.http.HttpHeaders;
import org.apache.http.HttpHost;
import org.apache.http.impl.client.CloseableHttpClient;

/**
 * http请求 执行器
 */
public interface HttpExecutor {

  String CONTENT_TYPE = HttpHeaders.CONTENT_TYPE;

  /**
   * 执行http请求
   *
   * @param request 请求信息
   * @param bodyType 请求体类型
   * @param responseType 响应体类型
   */
  HttpResponse execute(Request request, BodyType bodyType, ResponseType responseType)
      throws HttpClientException, IOException;

  /**
   * 设置请求编码
   */
  void setCharset(Charset charset);

  /**
   * 获取请求编码
   */
  Charset getCharset();

  /**
   * 设置httpClient
   */
  void setHttpClient(CloseableHttpClient httpClient);

  /**
   * 设置请求代理
   */
  void setProxy(HttpHost proxy);

  /**
   * {@link HttpClientConfig#setTimeout(int, int)}
   */
  void setTimeout(int socketTimeout, int connectTimeout);
}
