/*
 * Copyright 2019 https://www.ifengxue.com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.ifengxue.http.executor;

import com.ifengxue.http.HttpClientException;
import com.ifengxue.http.annotation.BodyType;
import com.ifengxue.http.annotation.ResponseType;
import com.ifengxue.http.codec.CodecFactory;
import com.ifengxue.http.codec.JsonCodec;
import com.ifengxue.http.contract.HttpResponse;
import com.ifengxue.http.contract.impl.HttpClientHttpResponse;
import java.io.IOException;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;

/**
 * json请求执行器
 */
public class JsonHttpExecutor extends AbstractHttpExecutor {

  @Override
  public HttpResponse execute(Request request, BodyType bodyType,
      ResponseType responseType) throws HttpClientException, IOException {
    RequestBuilder builder = RequestBuilder.create(request.getMethod())
        .setUri(request.getUrl())
        .setCharset(charset)
        .setConfig(createConfig());
    request.getHeaderMap().forEach(builder::addHeader);
    JsonCodec codec = CodecFactory.findCodec(JsonCodec.class);
    Object body = request.getParameterMap();
    if (request.getBody() != null) {
      body = request.getBody();
    }
    if (body != null) {
      builder.setEntity(new StringEntity(codec.encode(body), ContentType.APPLICATION_JSON.withCharset(charset)));
    }
    if (!request.containsHeader(CONTENT_TYPE)) {
      builder.addHeader(CONTENT_TYPE, ContentType.APPLICATION_JSON.withCharset(getCharset()).toString());
    }
    return new HttpClientHttpResponse(httpClient.execute(builder.build()));
  }
}
