/*
 * Copyright 2018 https://www.ifengxue.com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.ifengxue.http.executor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;

/**
 * 参数工具类
 */
public enum ParameterUtil {
  ;

  /**
   * 创建{@link NameValuePair}
   *
   * @param name 参数名称
   * @param value 参数值
   */
  @SuppressWarnings("unchecked")
  public static List<NameValuePair> createNameValueParis(String name, Object value) {
    Objects.requireNonNull(name, "name == null");
    if (value == null) {
      return Collections.singletonList(new BasicNameValuePair(name, null));
    }
    if (value.getClass().isArray()) {
      Object[] ary = (Object[]) value;
      List<NameValuePair> nvps = new ArrayList<>(ary.length);
      for (Object anAry : ary) {
        nvps.add(new BasicNameValuePair(name, Optional.ofNullable(anAry).map(Object::toString).orElse(null)));
      }
      return nvps;
    } else if (value instanceof Iterable) {
      List<NameValuePair> nvps = new LinkedList<>();
      ((Iterable) value).forEach(
          v -> nvps.add(new BasicNameValuePair(name, Optional.ofNullable(v).map(Object::toString).orElse(null))));
      return nvps;
    } else {
      return Collections.singletonList(new BasicNameValuePair(name, value.toString()));
    }
  }
}
