/*
 * Copyright 2019 https://www.ifengxue.com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.ifengxue.http.executor;

import com.ifengxue.http.HttpClientException;
import com.ifengxue.http.annotation.BodyType;
import com.ifengxue.http.annotation.ResponseType;
import com.ifengxue.http.contract.HttpResponse;
import com.ifengxue.http.contract.impl.HttpClientHttpResponse;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.ContentType;

/**
 * url-encoded执行器
 */
public class UrlEncodedHttpExecutor extends AbstractHttpExecutor {

  @Override
  public HttpResponse execute(Request request, BodyType bodyType,
      ResponseType responseType)
      throws HttpClientException, IOException {
    if (request.getBody() != null) {
      throw new HttpClientException("Body type " + bodyType.name() + " not support request body.");
    }
    RequestBuilder builder = RequestBuilder.create(request.getMethod())
        .setUri(request.getUrl())
        .setCharset(charset)
        .setConfig(createConfig());
    // 设置请求头
    request.getHeaderMap().forEach(builder::addHeader);
    for (Map.Entry<String, Object> entry : request.getParameterMap().entrySet()) {
      List<NameValuePair> nvps = ParameterUtil.createNameValueParis(entry.getKey(), entry.getValue());
      nvps.forEach(builder::addParameter);
    }
    if (!request.containsHeader(CONTENT_TYPE)) {
      builder.addHeader(CONTENT_TYPE, ContentType.APPLICATION_FORM_URLENCODED.withCharset(getCharset()).toString());
    }
    return new HttpClientHttpResponse(httpClient.execute(builder.build()));
  }
}
