/*
 * Copyright 2019 https://www.ifengxue.com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package com.ifengxue.http.parser;

import com.ifengxue.http.HttpClientException;
import com.ifengxue.http.annotation.ResponseType;
import com.ifengxue.http.codec.CodecFactory;
import com.ifengxue.http.codec.JsonCodec;
import com.ifengxue.http.codec.XmlCodec;

public final class HttpParserFactory {

  public HttpParser getHttpParser(ResponseType responseType) {
    HttpParser httpParser;
    switch (responseType) {
      case TEXT:
        httpParser = new StringHttpParser();
        break;
      case APPLICATION_JSON:
        httpParser = new CodecHttpParser(CodecFactory.findCodec(JsonCodec.class));
        break;
      case APPLICATION_XML:
        httpParser = new CodecHttpParser(CodecFactory.findCodec(XmlCodec.class));
        break;
      case STREAM:
        httpParser = new StreamHttpParser();
        break;
      case HEADER:
        httpParser = new HeaderHttpParser();
        break;
      default:
        throw new HttpClientException("Not support response type:" + responseType);
    }
    return httpParser;
  }
}
