/*
 * Copyright 2019 https://www.ifengxue.com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package com.ifengxue.http.proxy;

import com.ifengxue.http.HttpClientException;
import com.ifengxue.http.annotation.BodyType;
import com.ifengxue.http.annotation.ResponseType;
import com.ifengxue.http.contract.HttpResponse;
import com.ifengxue.http.executor.HttpExecutor;
import com.ifengxue.http.executor.Request;
import com.ifengxue.http.parser.HttpParser;
import java.io.IOException;
import java.lang.reflect.Method;

/**
 * http 请求拦截器
 */
public interface Interceptor {

  /**
   * 在请求之前执行
   *
   * @param method 被调用方法
   * @param request 请求数据
   * @param bodyType 请求类型
   * @param responseType 响应类型
   * @param executor 请求执行器
   * @param <T> 返回值
   * @return 返回<code>null</code>则发出请求，否则直接返回
   */
  <T> T beforeRequest(Method method, Request request, BodyType bodyType, ResponseType responseType,
      HttpExecutor executor) throws HttpClientException;

  /**
   * 在请求之后，解析之前执行
   *
   * @param method 被调用方法
   * @param request 请求数据
   * @param bodyType 请求类型
   * @param responseType 响应类型
   * @param httpResponse 响应内容
   * @param httpParser 响应内容解析器
   * @param <T> 返回<code>null</code>则调用解析器解析，否则直接返回
   */
  <T> T beforeParse(Method method, Request request, BodyType bodyType, ResponseType responseType,
      HttpResponse httpResponse, HttpParser httpParser) throws HttpClientException, IOException;
}
