/*
 * Copyright 2019 https://www.ifengxue.com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.ifengxue.http.proxy;

import com.ifengxue.http.HttpClientException;
import com.ifengxue.http.annotation.BodyType;
import com.ifengxue.http.annotation.ResponseType;
import com.ifengxue.http.contract.HttpResponse;
import com.ifengxue.http.executor.HttpExecutor;
import com.ifengxue.http.executor.Request;
import com.ifengxue.http.parser.HttpParser;
import java.io.IOException;
import java.lang.reflect.Method;

public class InterceptorAdaptor implements Interceptor {

  @Override
  public <T> T beforeRequest(Method method, Request request, BodyType bodyType, ResponseType responseType,
      HttpExecutor executor) throws HttpClientException {
    // do nothing
    return null;
  }

  @Override
  public <T> T beforeParse(Method method, Request request, BodyType bodyType, ResponseType responseType,
      HttpResponse httpResponse, HttpParser httpParser) throws HttpClientException, IOException {
    // do nothing
    return null;
  }
}
