/*
 * Decompiled with CFR 0.152.
 */
package com.ifengxue.http.codec;

import com.ifengxue.http.codec.Codec;
import com.ifengxue.http.codec.FastjsonJsonCodec;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public final class CodecFactory {
    private static final Map<Class<? extends Codec>, Codec> codecCache = new ConcurrentHashMap<Class<? extends Codec>, Codec>();
    private static final List<Codec> codecs = new ArrayList<Codec>();

    public static synchronized void registerCodec(Codec codec) {
        codecCache.put(codec.getClass(), codec);
        codecs.add(codec);
    }

    public static <T extends Codec> T findCodec(Class<T> codecClass) {
        Codec codec = codecCache.computeIfAbsent(codecClass, clazz -> {
            for (Codec c : codecs) {
                if (!codecClass.isAssignableFrom(c.getClass())) continue;
                return c;
            }
            return null;
        });
        return (T)Optional.ofNullable(codec).orElseThrow(() -> new NoSuchElementException("codec type " + codecClass.getName() + " can't be found."));
    }

    static {
        CodecFactory.registerCodec(new FastjsonJsonCodec());
    }
}

