/*
 * Decompiled with CFR 0.152.
 */
package com.ifengxue.http.codec;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ifengxue.http.codec.CodecException;
import com.ifengxue.http.codec.JsonCodec;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Optional;

public class FastjsonJsonCodec
implements JsonCodec {
    private final SerializeConfig serializeConfig;
    private final SerializerFeature[] serializerFeatures;
    private final Feature[] features;

    public FastjsonJsonCodec() {
        this(null, null, null);
    }

    public FastjsonJsonCodec(SerializeConfig serializeConfig, SerializerFeature[] serializerFeatures, Feature[] features) {
        this.serializeConfig = Optional.ofNullable(serializeConfig).orElseGet(SerializeConfig::getGlobalInstance);
        this.serializerFeatures = Optional.ofNullable(serializerFeatures).orElseGet(() -> new SerializerFeature[0]);
        this.features = Optional.ofNullable(features).orElseGet(() -> new Feature[0]);
    }

    @Override
    public <T> String encode(T obj) {
        return JSON.toJSONString(obj, (SerializeConfig)this.serializeConfig, (SerializerFeature[])this.serializerFeatures);
    }

    @Override
    public <T> Map<String, Object> decode(T obj) {
        Object jsonObj = JSON.toJSON(obj, (SerializeConfig)this.serializeConfig);
        if (jsonObj instanceof Map) {
            return (Map)jsonObj;
        }
        throw new CodecException(obj.getClass().getName() + " can't be cast to Map");
    }

    @Override
    public <T> T decode(String text, Type type) {
        return (T)JSON.parseObject((String)text, (Type)type, (Feature[])this.features);
    }

    @Override
    public <T> T decode(String text, Class<T> clazz) {
        return (T)JSON.parseObject((String)text, clazz, (Feature[])this.features);
    }
}

