/*
 * Decompiled with CFR 0.152.
 */
package com.ifengxue.http.codec;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.xml.JacksonXmlModule;
import com.fasterxml.jackson.dataformat.xml.XmlFactory;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import com.ifengxue.http.codec.CodecException;
import com.ifengxue.http.codec.XmlCodec;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;

public class JacksonXmlCodec
implements XmlCodec {
    private final XmlMapper xmlMapper;

    public JacksonXmlCodec() {
        this(JacksonXmlCodec.createXmlMapper());
    }

    private static XmlMapper createXmlMapper() {
        JacksonXmlModule module = new JacksonXmlModule();
        module.setDefaultUseWrapper(true);
        XMLInputFactory xmlInputFactory = XMLInputFactory.newFactory();
        XmlFactory xmlFactory = new XmlFactory(xmlInputFactory);
        XmlMapper xmlMapper = new XmlMapper(xmlFactory, module);
        xmlMapper.enable(ToXmlGenerator.Feature.WRITE_XML_DECLARATION);
        xmlMapper.enable(SerializationFeature.INDENT_OUTPUT);
        return xmlMapper;
    }

    public JacksonXmlCodec(XmlMapper xmlMapper) {
        this.xmlMapper = xmlMapper;
    }

    @Override
    public <T> String encode(T obj) {
        try {
            return this.xmlMapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new CodecException(e);
        }
    }

    @Override
    public <T> Map<String, Object> decode(T obj) {
        try {
            return (Map)this.xmlMapper.readValue(this.encode(obj), (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (IOException e) {
            throw new CodecException(e);
        }
    }

    @Override
    public <T> T decode(String text, final Type type) {
        try {
            return (T)this.xmlMapper.readValue(text, (TypeReference)new TypeReference<Object>(){

                public Type getType() {
                    return type;
                }
            });
        }
        catch (IOException e) {
            throw new CodecException(e);
        }
    }

    @Override
    public <T> T decode(String text, Class<T> clazz) {
        try {
            return (T)this.xmlMapper.readValue(text, clazz);
        }
        catch (IOException e) {
            throw new CodecException(e);
        }
    }
}

