/*
 * Decompiled with CFR 0.152.
 */
package com.ifengxue.http.collection;

import com.ifengxue.http.collection.MultiMap;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class MultiValueMap<K>
implements MultiMap<K> {
    private Map<K, Object> internalMap;

    public MultiValueMap() {
        this.internalMap = new HashMap<K, Object>();
    }

    public MultiValueMap(int initialCapacity) {
        this.internalMap = new HashMap<K, Object>(initialCapacity);
    }

    @Override
    public int size(K key) {
        if (!this.containsKey(key)) {
            return 0;
        }
        Object value = this.get(key);
        if (value instanceof Collection) {
            return ((Collection)value).size();
        }
        if (value.getClass().isArray()) {
            return Array.getLength(value);
        }
        return 1;
    }

    @Override
    public int size() {
        return this.internalMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.internalMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.internalMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        for (Map.Entry<K, Object> entry : this.internalMap.entrySet()) {
            if (value instanceof Collection && value.equals(entry.getValue())) {
                return true;
            }
            if (!(entry.getValue() instanceof Collection) && Objects.equals(entry.getValue(), value)) {
                return true;
            }
            if (!(entry.getValue() instanceof Collection) || !((Collection)entry.getValue()).contains(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object get(Object key) {
        return this.internalMap.get(key);
    }

    @Override
    public Object put(K key, Object value) {
        if (!this.internalMap.containsKey(key)) {
            return this.internalMap.put(key, value);
        }
        Object oldValue = this.internalMap.get(key);
        if (oldValue instanceof Collection) {
            ((Collection)oldValue).add(value);
            return oldValue;
        }
        if (oldValue.getClass().isArray()) {
            int length = Array.getLength(oldValue);
            Object targetArray = Array.newInstance(oldValue.getClass().getComponentType(), length + 1);
            System.arraycopy(oldValue, 0, targetArray, 0, length);
            Array.set(targetArray, length, value);
            this.internalMap.put(key, targetArray);
            return targetArray;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(oldValue);
        list.add(value);
        return this.internalMap.put(key, list);
    }

    @Override
    public Object remove(Object key) {
        return this.internalMap.remove(key);
    }

    @Override
    public void putAll(Map<? extends K, ?> m) {
        m.forEach(this::put);
    }

    @Override
    public void clear() {
        this.internalMap.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.internalMap.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.internalMap.values();
    }

    @Override
    public Set<Map.Entry<K, Object>> entrySet() {
        return this.internalMap.entrySet();
    }
}

