/*
 * Decompiled with CFR 0.152.
 */
package com.ifengxue.http.contract.impl;

import com.ifengxue.http.contract.BasicHeader;
import com.ifengxue.http.contract.Header;
import com.ifengxue.http.contract.HttpResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Locale;
import java.util.Optional;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;

public class HttpClientHttpResponse
implements HttpResponse {
    private final CloseableHttpResponse httpResponse;

    public HttpClientHttpResponse(CloseableHttpResponse httpResponse) {
        this.httpResponse = httpResponse;
    }

    @Override
    public int getStatusCode() {
        return this.httpResponse.getStatusLine().getStatusCode();
    }

    @Override
    public String getReasonPhrase() {
        return this.httpResponse.getStatusLine().getReasonPhrase();
    }

    @Override
    public boolean isChunked() {
        return this.httpResponse.getEntity().isChunked();
    }

    @Override
    public long getContentLength() {
        return this.httpResponse.getEntity().getContentLength();
    }

    @Override
    public InputStream getContent() throws IOException, UnsupportedEncodingException {
        return this.httpResponse.getEntity().getContent();
    }

    @Override
    public String getContent(String charset) throws IOException, UnsupportedEncodingException {
        return EntityUtils.toString((HttpEntity)this.httpResponse.getEntity(), (String)charset);
    }

    @Override
    public String getContent(Charset charset) throws IOException {
        return EntityUtils.toString((HttpEntity)this.httpResponse.getEntity(), (Charset)charset);
    }

    @Override
    public void setContent(InputStream inputStream, String mimeType, Charset charset) {
        this.httpResponse.setEntity((HttpEntity)new InputStreamEntity(inputStream, ContentType.create((String)mimeType, (Charset)charset)));
    }

    @Override
    public void setContent(String content, String mimeType, Charset charset) {
        this.httpResponse.setEntity((HttpEntity)new StringEntity(content, ContentType.create((String)mimeType, (Charset)charset)));
    }

    @Override
    public void setContent(byte[] data, String mimeType, Charset charset) {
        this.httpResponse.setEntity((HttpEntity)new ByteArrayEntity(data, ContentType.create((String)mimeType, (Charset)charset)));
    }

    @Override
    public String getHeaderValue(String headerName) {
        return this.httpResponse.getFirstHeader(headerName).getValue();
    }

    @Override
    public Header getFirstHeader(String headerName) {
        return Optional.ofNullable(this.httpResponse.getFirstHeader(headerName)).map(h -> new BasicHeader(h.getName(), h.getValue())).orElse(null);
    }

    @Override
    public Header[] getHeaders(String headerName) {
        return (Header[])Arrays.stream(this.httpResponse.getHeaders(headerName)).map(h -> new BasicHeader(h.getName(), h.getValue())).toArray(BasicHeader[]::new);
    }

    @Override
    public Header[] getAllHeaders() {
        return (Header[])Arrays.stream(this.httpResponse.getAllHeaders()).map(h -> new BasicHeader(h.getName(), h.getValue())).toArray(BasicHeader[]::new);
    }

    @Override
    public String getContentType() {
        return this.httpResponse.getEntity().getContentType().getValue();
    }

    @Override
    public Locale getLocale() {
        return this.httpResponse.getLocale();
    }

    @Override
    public void transferTo(OutputStream outputStream) throws IOException {
        this.httpResponse.getEntity().writeTo(outputStream);
    }

    @Override
    public void close() throws IOException {
        this.httpResponse.close();
    }
}

