/*
 * Decompiled with CFR 0.152.
 */
package com.ifengxue.http.executor;

import com.ifengxue.http.executor.HttpExecutor;
import com.ifengxue.http.proxy.HttpClientConfig;
import java.nio.charset.Charset;
import org.apache.http.HttpHost;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.CloseableHttpClient;

public abstract class AbstractHttpExecutor
implements HttpExecutor {
    protected Charset charset = HttpClientConfig.UTF_8;
    protected CloseableHttpClient httpClient;
    protected HttpHost proxy;
    protected int socketTimeout = -1;
    protected int connectTimeout = -1;

    @Override
    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    @Override
    public Charset getCharset() {
        return this.charset;
    }

    @Override
    public void setHttpClient(CloseableHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @Override
    public void setProxy(HttpHost proxy) {
        this.proxy = proxy;
    }

    @Override
    public void setTimeout(int socketTimeout, int connectTimeout) {
        this.socketTimeout = socketTimeout;
        this.connectTimeout = connectTimeout;
    }

    protected RequestConfig createConfig() {
        if (this.proxy == null && this.socketTimeout < 0 && this.connectTimeout < 0) {
            return null;
        }
        RequestConfig.Builder builder = RequestConfig.custom();
        if (this.proxy != null) {
            builder.setProxy(this.proxy);
        }
        if (this.socketTimeout >= 0) {
            builder.setSocketTimeout(this.socketTimeout);
        }
        if (this.connectTimeout >= 0) {
            builder.setConnectTimeout(this.connectTimeout);
        }
        return builder.build();
    }
}

